/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;

public final class SQLServerResultSetMetaData
implements ResultSetMetaData {
    private SQLServerConnection con;
    private SQLServerResultSet rs;
    public int nBeforeExecuteCols;

    public SQLServerResultSetMetaData(SQLServerConnection sQLServerConnection, SQLServerResultSet sQLServerResultSet) {
        this.con = sQLServerConnection;
        this.rs = sQLServerResultSet;
    }

    private void checkIndex(int n) throws SQLServerException {
        if (n > 0 && n <= this.rs.getColumnCount()) {
            return;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
        Object[] objectArray = new Object[]{new Integer(n)};
        SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, false);
    }

    public String getCatalogName(int n) throws SQLServerException {
        this.checkIndex(n);
        return "";
    }

    public int getColumnCount() throws SQLServerException {
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getColumnCount();
    }

    public int getColumnDisplaySize(int n) throws SQLServerException {
        this.checkIndex(n);
        int n2 = this.rs.getColumn(n).getTypeInfo().getTDSType();
        int n3 = this.getPrecision(n);
        if (DataTypes.isBinary(n2) && 36 != n2) {
            n3 = n3 < 0x3FFFFFFF ? 2 * n3 : Integer.MAX_VALUE;
        } else {
            switch (n2) {
                case 38: 
                case 52: 
                case 56: 
                case 127: {
                    if (n3 <= 3) break;
                    ++n3;
                    break;
                }
                case 60: 
                case 106: 
                case 108: 
                case 110: 
                case 122: {
                    n3 += 2;
                    break;
                }
                case 16: 
                case 59: 
                case 62: 
                case 109: {
                    n3 = 7 == n3 ? 13 : 22;
                }
            }
        }
        return n3;
    }

    public String getColumnLabel(int n) throws SQLServerException {
        this.checkIndex(n);
        return this.rs.getColumn((int)n).name;
    }

    public String getColumnName(int n) throws SQLServerException {
        this.checkIndex(n);
        return this.rs.getColumn((int)n).name;
    }

    public int getColumnType(int n) throws SQLServerException {
        this.checkIndex(n);
        int n2 = this.rs.getColumn(n).getTypeInfo().getNativeType();
        int n3 = this.rs.getColumn(n).getTypeInfo().getMaxLength();
        return DataTypes.nativeTypeToJdbcType(this.con, n2, n3);
    }

    public String getColumnTypeName(int n) throws SQLServerException {
        this.checkIndex(n);
        int n2 = this.rs.getColumn(n).getTypeInfo().getNativeType();
        int n3 = this.rs.getColumn(n).getTypeInfo().getMaxLength();
        if (240 == n2) {
            return this.rs.getColumn(n).getTypeInfo().getUDTTDSHeader().getTypeName();
        }
        return DataTypes.getDataTypeSQLServerName(n2, n3, this.rs.getColumn(n).getTypeInfo().getUserType());
    }

    public int getPrecision(int n) throws SQLServerException {
        this.checkIndex(n);
        return this.rs.getColumn(n).getTypeInfo().getPrecision();
    }

    public int getScale(int n) throws SQLServerException {
        this.checkIndex(n);
        return this.rs.getColumn(n).getTypeInfo().getScale();
    }

    public String getSchemaName(int n) throws SQLServerException {
        this.checkIndex(n);
        return "";
    }

    public String getTableName(int n) throws SQLServerException {
        this.checkIndex(n);
        return this.rs.getColumn((int)n).tableName;
    }

    public boolean isAutoIncrement(int n) throws SQLServerException {
        this.checkIndex(n);
        boolean bl = this.rs.getColumn(n).getTypeInfo().isIdentity();
        return bl;
    }

    public boolean isCaseSensitive(int n) throws SQLServerException {
        this.checkIndex(n);
        return this.rs.getColumn(n).getTypeInfo().isCaseSensitive();
    }

    public boolean isCurrency(int n) throws SQLServerException {
        this.checkIndex(n);
        int n2 = this.rs.getColumn(n).getTypeInfo().getNativeType();
        switch (n2) {
            case 14: 
            case 110: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLServerException {
        this.checkIndex(n);
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    public int isNullable(int n) throws SQLServerException {
        this.checkIndex(n);
        return this.rs.getColumn(n).getTypeInfo().isNullable() ? 1 : 0;
    }

    public boolean isReadOnly(int n) throws SQLServerException {
        this.checkIndex(n);
        return TypeInfo.UPDATABLE_READ_ONLY == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    public boolean isSearchable(int n) throws SQLServerException {
        this.checkIndex(n);
        int n2 = this.rs.getColumn(n).getTypeInfo().getNativeType();
        return DataTypes.getDataType((int)n2, (int)0).bSearchable;
    }

    public boolean isSigned(int n) throws SQLServerException {
        this.checkIndex(n);
        int n2 = this.rs.getColumn(n).getTypeInfo().getNativeType();
        return DataTypes.isSigned(n2);
    }

    public boolean isWritable(int n) throws SQLServerException {
        this.checkIndex(n);
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getColumn(n).getTypeInfo().getUpdatability() || TypeInfo.UPDATABLE_UNKNOWN == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    public String getColumnClassName(int n) throws SQLServerException {
        this.checkIndex(n);
        int n2 = this.rs.getColumn(n).getTypeInfo().getNativeType();
        int n3 = this.rs.getColumn(n).getTypeInfo().getMaxLength();
        return DataTypes.getDataType((int)n2, (int)n3).sClassName;
    }
}

