/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ShortVector;
import gnu.math.UShort;

public class U16Vector
extends ShortVector<UShort> {
    public U16Vector() {
        this.data = empty;
    }

    public U16Vector(int size, short value) {
        short[] array = new short[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public U16Vector(int size) {
        this(new short[size]);
    }

    public U16Vector(short[] data) {
        this.data = data;
    }

    public U16Vector(short[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final int getIntRaw(int index) {
        return this.data[index] & 0xFFFF;
    }

    @Override
    public final UShort get(int index) {
        return UShort.valueOf(this.data[this.effectiveIndex(index)]);
    }

    @Override
    public final UShort getRaw(int index) {
        return UShort.valueOf(this.data[index]);
    }

    @Override
    public final void setRaw(int index, UShort value) {
        this.data[index] = value.shortValue();
    }

    @Override
    protected U16Vector newInstance(int newLength) {
        return new U16Vector(newLength < 0 ? this.data : new short[newLength]);
    }

    public static U16Vector castOrNull(Object obj) {
        if (obj instanceof short[]) {
            return new U16Vector((short[])obj);
        }
        if (obj instanceof U16Vector) {
            return (U16Vector)obj;
        }
        return null;
    }

    public static U16Vector cast(Object value) {
        U16Vector vec = U16Vector.castOrNull(value);
        if (vec == null) {
            Object msg = value == null ? "cannot convert null to U16Vector" : "cannot convert a " + value.getClass().getName() + " to U16Vector";
            throw new ClassCastException((String)msg);
        }
        return vec;
    }

    @Override
    public int getElementKind() {
        return 19;
    }

    @Override
    public String getTag() {
        return "u16";
    }

    public int compareTo(Object obj) {
        return U16Vector.compareToInt(this, (U16Vector)obj);
    }
}

