"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var config_1 = require("../../layout/config/config");
var picked_shapes_1 = require("./picked_shapes");
var pie_spec_1 = require("./pie_spec");
var scenegraph_1 = require("./scenegraph");
var EMPTY_TOOLTIP = Object.freeze({
    header: null,
    values: [],
});
exports.getTooltipInfoSelector = re_reselect_1.default([pie_spec_1.getPieSpec, picked_shapes_1.getPickedShapes], function (pieSpec, pickedShapes) {
    if (!pieSpec) {
        return EMPTY_TOOLTIP;
    }
    var valueGetter = pieSpec.valueGetter, valueFormatter = pieSpec.valueFormatter, labelFormatters = pieSpec.layers;
    if (!valueFormatter || !labelFormatters) {
        return EMPTY_TOOLTIP;
    }
    var tooltipInfo = {
        header: null,
        values: [],
    };
    var valueGetterFun = scenegraph_1.valueGetterFunction(valueGetter);
    var primaryValueGetterFun = valueGetterFun === config_1.percentValueGetter ? config_1.sumValueGetter : valueGetterFun;
    pickedShapes.forEach(function (shape) {
        var _a;
        var labelFormatter = labelFormatters[shape.depth - 1];
        var formatter = (_a = labelFormatter) === null || _a === void 0 ? void 0 : _a.nodeLabel;
        tooltipInfo.values.push({
            label: formatter ? formatter(shape.dataName) : shape.dataName,
            color: shape.fillColor,
            isHighlighted: false,
            isVisible: true,
            seriesIdentifier: {
                specId: pieSpec.id,
                key: pieSpec.id,
            },
            value: valueFormatter(primaryValueGetterFun(shape)) + " (" + pieSpec.percentFormatter(config_1.percentValueGetter(shape)) + ")",
            valueAccessor: shape.depth,
        });
    });
    return tooltipInfo;
})(function (state) { return state.chartId; });
//# sourceMappingURL=tooltip.js.map