"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var __1 = require("../..");
var tooltip_1 = require("../../../components/tooltip");
var get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
var commons_1 = require("../../../utils/commons");
var xy_chart_1 = require("../renderer/canvas/xy_chart");
var annotations_1 = require("../renderer/dom/annotations");
var brush_1 = require("../renderer/dom/brush");
var crosshair_1 = require("../renderer/dom/crosshair");
var highlighter_1 = require("../renderer/dom/highlighter");
var compute_legend_1 = require("./selectors/compute_legend");
var get_cursor_pointer_1 = require("./selectors/get_cursor_pointer");
var get_highlighted_values_1 = require("./selectors/get_highlighted_values");
var get_legend_items_labels_1 = require("./selectors/get_legend_items_labels");
var get_specs_1 = require("./selectors/get_specs");
var get_tooltip_position_1 = require("./selectors/get_tooltip_position");
var get_tooltip_values_highlighted_geoms_1 = require("./selectors/get_tooltip_values_highlighted_geoms");
var is_brush_available_1 = require("./selectors/is_brush_available");
var is_brushing_1 = require("./selectors/is_brushing");
var is_chart_empty_1 = require("./selectors/is_chart_empty");
var is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
var on_brush_end_caller_1 = require("./selectors/on_brush_end_caller");
var on_element_click_caller_1 = require("./selectors/on_element_click_caller");
var on_element_out_caller_1 = require("./selectors/on_element_out_caller");
var on_element_over_caller_1 = require("./selectors/on_element_over_caller");
var on_pointer_move_caller_1 = require("./selectors/on_pointer_move_caller");
var XYAxisChartState = (function () {
    function XYAxisChartState() {
        this.onElementClickCaller = on_element_click_caller_1.createOnElementClickCaller();
        this.onElementOverCaller = on_element_over_caller_1.createOnElementOverCaller();
        this.onElementOutCaller = on_element_out_caller_1.createOnElementOutCaller();
        this.onBrushEndCaller = on_brush_end_caller_1.createOnBrushEndCaller();
        this.onPointerMoveCaller = on_pointer_move_caller_1.createOnPointerMoveCaller();
        this.chartType = __1.ChartTypes.XYAxis;
        this.legendId = commons_1.htmlIdGenerator()('legend');
    }
    XYAxisChartState.prototype.isInitialized = function (globalState) {
        return get_specs_1.getSeriesSpecsSelector(globalState).length > 0 ? get_internal_is_intialized_1.InitStatus.Initialized : get_internal_is_intialized_1.InitStatus.SpecNotInitialized;
    };
    XYAxisChartState.prototype.isBrushAvailable = function (globalState) {
        return is_brush_available_1.isBrushAvailableSelector(globalState);
    };
    XYAxisChartState.prototype.isBrushing = function (globalState) {
        return is_brushing_1.isBrushingSelector(globalState);
    };
    XYAxisChartState.prototype.isChartEmpty = function (globalState) {
        return is_chart_empty_1.isChartEmptySelector(globalState);
    };
    XYAxisChartState.prototype.getLegendItemsLabels = function (globalState) {
        return get_legend_items_labels_1.getLegendItemsLabelsSelector(globalState);
    };
    XYAxisChartState.prototype.getLegendItems = function (globalState) {
        return compute_legend_1.computeLegendSelector(globalState);
    };
    XYAxisChartState.prototype.getLegendExtraValues = function (globalState) {
        return get_highlighted_values_1.getHighlightedValuesSelector(globalState);
    };
    XYAxisChartState.prototype.chartRenderer = function (containerRef, forwardStageRef) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(crosshair_1.Crosshair, null),
            react_1.default.createElement(xy_chart_1.XYChart, { forwardStageRef: forwardStageRef }),
            react_1.default.createElement(tooltip_1.Tooltip, { getChartContainerRef: containerRef }),
            react_1.default.createElement(annotations_1.Annotations, { getChartContainerRef: containerRef }),
            react_1.default.createElement(highlighter_1.Highlighter, null),
            react_1.default.createElement(brush_1.BrushTool, null)));
    };
    XYAxisChartState.prototype.getPointerCursor = function (globalState) {
        return get_cursor_pointer_1.getPointerCursorSelector(globalState);
    };
    XYAxisChartState.prototype.isTooltipVisible = function (globalState) {
        return is_tooltip_visible_1.isTooltipVisibleSelector(globalState);
    };
    XYAxisChartState.prototype.getTooltipInfo = function (globalState) {
        return get_tooltip_values_highlighted_geoms_1.getTooltipInfoSelector(globalState);
    };
    XYAxisChartState.prototype.getTooltipAnchor = function (globalState) {
        return get_tooltip_position_1.getTooltipAnchorPositionSelector(globalState);
    };
    XYAxisChartState.prototype.eventCallbacks = function (globalState) {
        this.onElementOverCaller(globalState);
        this.onElementOutCaller(globalState);
        this.onElementClickCaller(globalState);
        this.onBrushEndCaller(globalState);
        this.onPointerMoveCaller(globalState);
    };
    return XYAxisChartState;
}());
exports.XYAxisChartState = XYAxisChartState;
//# sourceMappingURL=chart_state.js.map