"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../../../scales/constants");
var commons_1 = require("../../../utils/commons");
exports.datumXSortPredicate = function (xScaleType, sortedXValues) { return function (a, b) {
    if (xScaleType === constants_1.ScaleType.Ordinal || typeof a.x === 'string' || typeof b.x === 'string') {
        return sortedXValues ? sortedXValues.indexOf(a.x) - sortedXValues.indexOf(b.x) : 0;
    }
    return a.x - b.x;
}; };
function getYValueStackMap(dataseries, xValues) {
    var stackMap = new Map();
    var missingXValues = new Set(__spread(xValues));
    dataseries.forEach(function (ds, index) {
        var e_1, _a;
        ds.data.forEach(function (datum) {
            var stack = stackMap.get(datum.x) || new Array(dataseries.length).fill(0);
            stack[index] = datum.y1;
            stackMap.set(datum.x, stack);
            if (xValues.has(datum.x)) {
                missingXValues.delete(datum.x);
            }
        });
        try {
            for (var _b = __values(missingXValues.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var x = _c.value;
                var stack = stackMap.get(x) || new Array(dataseries.length).fill(0);
                stack[index] = 0;
                stackMap.set(x, stack);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    });
    return stackMap;
}
exports.getYValueStackMap = getYValueStackMap;
function computeYStackedMapValues(yValueStackMap, scaleToExtent) {
    var stackedValues = new Map();
    yValueStackMap.forEach(function (yStackArray, xValue) {
        var stackArray = yStackArray.reduce(function (acc, currentValue, index) {
            if (acc.values.length === 0) {
                if (scaleToExtent) {
                    return {
                        values: [currentValue, currentValue],
                        total: currentValue,
                    };
                }
                return {
                    values: [0, currentValue],
                    total: currentValue,
                };
            }
            return {
                values: __spread(acc.values, [acc.values[index] + currentValue]),
                total: acc.total + currentValue,
            };
        }, {
            values: [],
            total: 0,
        });
        var percent = stackArray.values.map(function (value) {
            if (stackArray.total === 0) {
                return 0;
            }
            return value / stackArray.total;
        });
        stackedValues.set(xValue, {
            values: stackArray.values,
            percent: percent,
            total: stackArray.total,
        });
    });
    return stackedValues;
}
exports.computeYStackedMapValues = computeYStackedMapValues;
function formatStackedDataSeriesValues(dataseries, scaleToExtent, isPercentageMode, xValues, xScaleType) {
    var yValueStackMap = getYValueStackMap(dataseries, xValues);
    var stackedValues = computeYStackedMapValues(yValueStackMap, scaleToExtent);
    var stackedDataSeries = dataseries.map(function (ds, seriesIndex) {
        var e_2, _a;
        var newData = [];
        var missingXValues = new Set(__spread(xValues));
        ds.data.forEach(function (data) {
            var formattedSeriesDatum = getStackedFormattedSeriesDatum(data, stackedValues, seriesIndex, scaleToExtent, isPercentageMode);
            if (formattedSeriesDatum === undefined) {
                return;
            }
            missingXValues.delete(data.x);
            newData.push(formattedSeriesDatum);
        });
        try {
            for (var _b = __values(missingXValues.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var x = _c.value;
                var filledSeriesDatum = getStackedFormattedSeriesDatum({
                    x: x,
                    y1: 0,
                    mark: null,
                    datum: null,
                }, stackedValues, seriesIndex, scaleToExtent, isPercentageMode, {
                    x: x,
                    y1: 0,
                });
                if (filledSeriesDatum) {
                    newData.push(filledSeriesDatum);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        var sortedXValues = __spread(xValues);
        newData.sort(exports.datumXSortPredicate(xScaleType, sortedXValues));
        return __assign(__assign({}, ds), { data: newData });
    });
    return stackedDataSeries;
}
exports.formatStackedDataSeriesValues = formatStackedDataSeriesValues;
function getStackedFormattedSeriesDatum(data, stackedValues, seriesIndex, scaleToExtent, isPercentageMode, filled) {
    if (isPercentageMode === void 0) { isPercentageMode = false; }
    var x = data.x, markValue = data.mark, datum = data.datum;
    var stack = stackedValues.get(x);
    if (!stack) {
        return;
    }
    var y1 = null;
    var y0 = null;
    if (isPercentageMode) {
        if (data.y1 != null) {
            y1 = stack.total !== 0 ? data.y1 / stack.total : 0;
        }
        if (data.y0 != null) {
            y0 = stack.total !== 0 ? data.y0 / stack.total : 0;
        }
    }
    else {
        y1 = data.y1;
        y0 = data.y0;
    }
    var computedY0;
    if (scaleToExtent) {
        computedY0 = y0 || y1;
    }
    else {
        computedY0 = y0 || null;
    }
    var initialY0 = y0 == null ? null : y0;
    var mark = commons_1.isDefined(markValue) ? markValue : null;
    if (seriesIndex === 0) {
        return __assign({ x: x,
            y1: y1, y0: computedY0, initialY1: y1, initialY0: initialY0,
            mark: mark,
            datum: datum }, (filled && { filled: filled }));
    }
    var stackY = isPercentageMode ? stack.percent[seriesIndex] : stack.values[seriesIndex];
    var stackedY1 = null;
    var stackedY0 = null;
    if (isPercentageMode) {
        stackedY1 = y1 !== null && stackY != null ? stackY + y1 : null;
        stackedY0 = y0 != null && stackY != null ? stackY + y0 : stackY;
    }
    else {
        if (stackY == null) {
            stackedY1 = y1 !== null ? y1 : null;
            stackedY0 = y0 != null ? y0 : stackY;
        }
        else {
            stackedY1 = y1 !== null ? stackY + y1 : null;
            stackedY0 = y0 != null ? stackY + y0 : stackY;
        }
        if (stackedY1 === null) {
            stackedY0 = null;
        }
    }
    return __assign({ x: x, y1: stackedY1, y0: stackedY0, initialY1: y1, initialY0: initialY0,
        mark: mark,
        datum: datum }, (filled && { filled: filled }));
}
exports.getStackedFormattedSeriesDatum = getStackedFormattedSeriesDatum;
//# sourceMappingURL=stacked_series_utils.js.map