"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var d3_array_1 = require("d3-array");
function computeOrdinalDataDomain(data, accessor, sorted, removeNull) {
    if (data.length === 0) {
        return [0];
    }
    var domain = data.map(accessor).filter(function (d) { return (removeNull ? d !== null : true); });
    var uniqueValues = __spread(new Set(domain));
    return sorted
        ? uniqueValues.sort(function (a, b) { return ("" + a).localeCompare("" + b); })
        : uniqueValues;
}
exports.computeOrdinalDataDomain = computeOrdinalDataDomain;
function getPaddedRange(start, end, domainOptions) {
    var _a, _b;
    if (!((_a = domainOptions) === null || _a === void 0 ? void 0 : _a.padding)) {
        return [start, end];
    }
    var computedPadding = 0;
    if (typeof domainOptions.padding === 'string') {
        var padding = domainOptions.padding.trim();
        if (/\d+%$/.test(padding.trim())) {
            var paddingPercent = Number.parseInt(padding.trim().slice(0, -1), 10);
            var delta = Math.abs(end - start);
            computedPadding = delta * (paddingPercent / 100);
        }
        else {
            var num = Number.parseFloat(padding);
            computedPadding = num && !isNaN(num) ? num : 0;
        }
    }
    else {
        computedPadding = domainOptions.padding;
    }
    if (computedPadding === 0) {
        return [start, end];
    }
    var newStart = start - computedPadding;
    var newEnd = end + computedPadding;
    if (_b = domainOptions.constrainPadding, (_b !== null && _b !== void 0 ? _b : true)) {
        return [
            start >= 0 && newStart < 0 ? 0 : newStart,
            end <= 0 && newEnd > 0 ? 0 : newEnd,
        ];
    }
    return [newStart, newEnd];
}
function computeDomainExtent(_a, domainOptions) {
    var _b = __read(_a, 2), start = _b[0], end = _b[1];
    var _c, _d;
    if (start != null && end != null) {
        var _e = __read(getPaddedRange(start, end, domainOptions), 2), paddedStart = _e[0], paddedEnd = _e[1];
        if (paddedStart >= 0 && paddedEnd >= 0) {
            return ((_c = domainOptions) === null || _c === void 0 ? void 0 : _c.fit) ? [paddedStart, paddedEnd] : [0, paddedEnd];
        }
        if (paddedStart < 0 && paddedEnd < 0) {
            return ((_d = domainOptions) === null || _d === void 0 ? void 0 : _d.fit) ? [paddedStart, paddedEnd] : [paddedStart, 0];
        }
        return [paddedStart, paddedEnd];
    }
    return [0, 0];
}
exports.computeDomainExtent = computeDomainExtent;
function computeContinuousDataDomain(data, accessor, domainOptions) {
    var _a, _b;
    var range = d3_array_1.extent(data, accessor);
    if (domainOptions === null) {
        return [(_a = range[0], (_a !== null && _a !== void 0 ? _a : 0)), (_b = range[1], (_b !== null && _b !== void 0 ? _b : 0))];
    }
    return computeDomainExtent(range, domainOptions);
}
exports.computeContinuousDataDomain = computeContinuousDataDomain;
//# sourceMappingURL=domain.js.map