"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileLayer = void 0;

var _url = _interopRequireDefault(require("url"));

var _ems_service = require("./ems_service");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FileLayer extends _ems_service.AbstractEmsService {
  constructor(config, emsClient, proxyPath) {
    super(config, emsClient, proxyPath);

    _defineProperty(this, "_config", void 0);

    this._config = config;
  }

  getFields() {
    return this._config.fields;
  }

  getFieldsInLanguage() {
    return this.getFields().map(field => {
      return {
        type: field.type,
        name: field.id,
        description: this._emsClient.getValueInLanguage(field.label)
      };
    });
  }

  getDisplayName() {
    const layerName = this._emsClient.getValueInLanguage(this._config.layer_name);

    return layerName ? layerName : '';
  }

  getId() {
    return this._config.layer_id;
  }

  hasId(id) {
    const matchesLegacyId = this._config.legacy_ids.indexOf(id) >= 0;
    return this._config.layer_id === id || matchesLegacyId;
  }

  getEMSHotLink() {
    const landingPageString = this._emsClient.getLandingPageUrl();

    const urlObject = _url.default.parse(landingPageString, true);

    urlObject.hash = `file/${this.getId()}`;
    urlObject.query = { ...urlObject.query,
      locale: this._emsClient.getLocale()
    };
    return _url.default.format(urlObject);
  }

  getDefaultFormatType() {
    const format = this._getDefaultFormat();

    return format.type;
  }

  getDefaultFormatMeta() {
    const format = this._getDefaultFormat();

    if ('meta' in format) {
      return format.meta;
    } else {
      return;
    }
  }

  getDefaultFormatUrl() {
    const format = this._getDefaultFormat();

    const url = this._proxyPath + this._getAbsoluteUrl(format.url);

    return this._emsClient.extendUrlWithParams(url);
  }

  getCreatedAt() {
    return this._config.created_at;
  }

  getApiUrl() {
    return this._emsClient.getFileApiUrl();
  }

  _getDefaultFormat() {
    const defaultFormat = this._config.formats.find(format => {
      return format.legacy_default;
    });

    if (defaultFormat) {
      return defaultFormat;
    }

    return this._config.formats[0];
  }

}

exports.FileLayer = FileLayer;