"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractCollectorsTask = extractCollectorsTask;

var ts = _interopRequireWildcard(require("typescript"));

var path = _interopRequireWildcard(require("path"));

var _extract_collectors = require("../extract_collectors");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function extractCollectorsTask({
  roots
}, restrictProgramToPath) {
  return roots.map(root => ({
    task: async () => {
      const tsConfig = ts.findConfigFile('./', ts.sys.fileExists, 'tsconfig.json');

      if (!tsConfig) {
        throw new Error('Could not find a valid tsconfig.json.');
      }

      const programPaths = await (0, _extract_collectors.getProgramPaths)(root.config);

      if (typeof restrictProgramToPath !== 'undefined') {
        const restrictProgramToPaths = Array.isArray(restrictProgramToPath) ? restrictProgramToPath : [restrictProgramToPath];
        const fullRestrictedPaths = restrictProgramToPaths.map(collectorPath => path.resolve(process.cwd(), collectorPath));
        const restrictedProgramPaths = programPaths.filter(programPath => fullRestrictedPaths.includes(programPath));

        if (restrictedProgramPaths.length) {
          root.parsedCollections = [...(0, _extract_collectors.extractCollectors)(restrictedProgramPaths, tsConfig)];
        }

        return;
      }

      root.parsedCollections = [...(0, _extract_collectors.extractCollectors)(programPaths, tsConfig)];
    },
    title: `Extracting collectors in ${root.config.root}`
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy90b29scy90YXNrcy9leHRyYWN0X2NvbGxlY3RvcnNfdGFzay50cyJdLCJuYW1lcyI6WyJleHRyYWN0Q29sbGVjdG9yc1Rhc2siLCJyb290cyIsInJlc3RyaWN0UHJvZ3JhbVRvUGF0aCIsIm1hcCIsInJvb3QiLCJ0YXNrIiwidHNDb25maWciLCJ0cyIsImZpbmRDb25maWdGaWxlIiwic3lzIiwiZmlsZUV4aXN0cyIsIkVycm9yIiwicHJvZ3JhbVBhdGhzIiwiY29uZmlnIiwicmVzdHJpY3RQcm9ncmFtVG9QYXRocyIsIkFycmF5IiwiaXNBcnJheSIsImZ1bGxSZXN0cmljdGVkUGF0aHMiLCJjb2xsZWN0b3JQYXRoIiwicGF0aCIsInJlc29sdmUiLCJwcm9jZXNzIiwiY3dkIiwicmVzdHJpY3RlZFByb2dyYW1QYXRocyIsImZpbHRlciIsInByb2dyYW1QYXRoIiwiaW5jbHVkZXMiLCJsZW5ndGgiLCJwYXJzZWRDb2xsZWN0aW9ucyIsInRpdGxlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBbUJBOztBQUNBOztBQUVBOzs7Ozs7QUF0QkE7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQXdCTyxTQUFTQSxxQkFBVCxDQUNMO0FBQUVDLEVBQUFBO0FBQUYsQ0FESyxFQUVMQyxxQkFGSyxFQUdMO0FBQ0EsU0FBT0QsS0FBSyxDQUFDRSxHQUFOLENBQVdDLElBQUQsS0FBVztBQUMxQkMsSUFBQUEsSUFBSSxFQUFFLFlBQVk7QUFDaEIsWUFBTUMsUUFBUSxHQUFHQyxFQUFFLENBQUNDLGNBQUgsQ0FBa0IsSUFBbEIsRUFBd0JELEVBQUUsQ0FBQ0UsR0FBSCxDQUFPQyxVQUEvQixFQUEyQyxlQUEzQyxDQUFqQjs7QUFDQSxVQUFJLENBQUNKLFFBQUwsRUFBZTtBQUNiLGNBQU0sSUFBSUssS0FBSixDQUFVLHVDQUFWLENBQU47QUFDRDs7QUFDRCxZQUFNQyxZQUFZLEdBQUcsTUFBTSx5Q0FBZ0JSLElBQUksQ0FBQ1MsTUFBckIsQ0FBM0I7O0FBRUEsVUFBSSxPQUFPWCxxQkFBUCxLQUFpQyxXQUFyQyxFQUFrRDtBQUNoRCxjQUFNWSxzQkFBc0IsR0FBR0MsS0FBSyxDQUFDQyxPQUFOLENBQWNkLHFCQUFkLElBQzNCQSxxQkFEMkIsR0FFM0IsQ0FBQ0EscUJBQUQsQ0FGSjtBQUlBLGNBQU1lLG1CQUFtQixHQUFHSCxzQkFBc0IsQ0FBQ1gsR0FBdkIsQ0FBNEJlLGFBQUQsSUFDckRDLElBQUksQ0FBQ0MsT0FBTCxDQUFhQyxPQUFPLENBQUNDLEdBQVIsRUFBYixFQUE0QkosYUFBNUIsQ0FEMEIsQ0FBNUI7QUFHQSxjQUFNSyxzQkFBc0IsR0FBR1gsWUFBWSxDQUFDWSxNQUFiLENBQXFCQyxXQUFELElBQ2pEUixtQkFBbUIsQ0FBQ1MsUUFBcEIsQ0FBNkJELFdBQTdCLENBRDZCLENBQS9COztBQUdBLFlBQUlGLHNCQUFzQixDQUFDSSxNQUEzQixFQUFtQztBQUNqQ3ZCLFVBQUFBLElBQUksQ0FBQ3dCLGlCQUFMLEdBQXlCLENBQUMsR0FBRywyQ0FBa0JMLHNCQUFsQixFQUEwQ2pCLFFBQTFDLENBQUosQ0FBekI7QUFDRDs7QUFDRDtBQUNEOztBQUVERixNQUFBQSxJQUFJLENBQUN3QixpQkFBTCxHQUF5QixDQUFDLEdBQUcsMkNBQWtCaEIsWUFBbEIsRUFBZ0NOLFFBQWhDLENBQUosQ0FBekI7QUFDRCxLQTFCeUI7QUEyQjFCdUIsSUFBQUEsS0FBSyxFQUFHLDRCQUEyQnpCLElBQUksQ0FBQ1MsTUFBTCxDQUFZVCxJQUFLO0FBM0IxQixHQUFYLENBQVYsQ0FBUDtBQTZCRCIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBMaWNlbnNlZCB0byBFbGFzdGljc2VhcmNoIEIuVi4gdW5kZXIgb25lIG9yIG1vcmUgY29udHJpYnV0b3JcbiAqIGxpY2Vuc2UgYWdyZWVtZW50cy4gU2VlIHRoZSBOT1RJQ0UgZmlsZSBkaXN0cmlidXRlZCB3aXRoXG4gKiB0aGlzIHdvcmsgZm9yIGFkZGl0aW9uYWwgaW5mb3JtYXRpb24gcmVnYXJkaW5nIGNvcHlyaWdodFxuICogb3duZXJzaGlwLiBFbGFzdGljc2VhcmNoIEIuVi4gbGljZW5zZXMgdGhpcyBmaWxlIHRvIHlvdSB1bmRlclxuICogdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTsgeW91IG1heVxuICogbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZyxcbiAqIHNvZnR3YXJlIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuXG4gKiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWVxuICogS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlXG4gKiBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kIGxpbWl0YXRpb25zXG4gKiB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgKiBhcyB0cyBmcm9tICd0eXBlc2NyaXB0JztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBUYXNrQ29udGV4dCB9IGZyb20gJy4vdGFza19jb250ZXh0JztcbmltcG9ydCB7IGV4dHJhY3RDb2xsZWN0b3JzLCBnZXRQcm9ncmFtUGF0aHMgfSBmcm9tICcuLi9leHRyYWN0X2NvbGxlY3RvcnMnO1xuXG5leHBvcnQgZnVuY3Rpb24gZXh0cmFjdENvbGxlY3RvcnNUYXNrKFxuICB7IHJvb3RzIH06IFRhc2tDb250ZXh0LFxuICByZXN0cmljdFByb2dyYW1Ub1BhdGg/OiBzdHJpbmcgfCBzdHJpbmdbXVxuKSB7XG4gIHJldHVybiByb290cy5tYXAoKHJvb3QpID0+ICh7XG4gICAgdGFzazogYXN5bmMgKCkgPT4ge1xuICAgICAgY29uc3QgdHNDb25maWcgPSB0cy5maW5kQ29uZmlnRmlsZSgnLi8nLCB0cy5zeXMuZmlsZUV4aXN0cywgJ3RzY29uZmlnLmpzb24nKTtcbiAgICAgIGlmICghdHNDb25maWcpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdDb3VsZCBub3QgZmluZCBhIHZhbGlkIHRzY29uZmlnLmpzb24uJyk7XG4gICAgICB9XG4gICAgICBjb25zdCBwcm9ncmFtUGF0aHMgPSBhd2FpdCBnZXRQcm9ncmFtUGF0aHMocm9vdC5jb25maWcpO1xuXG4gICAgICBpZiAodHlwZW9mIHJlc3RyaWN0UHJvZ3JhbVRvUGF0aCAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgY29uc3QgcmVzdHJpY3RQcm9ncmFtVG9QYXRocyA9IEFycmF5LmlzQXJyYXkocmVzdHJpY3RQcm9ncmFtVG9QYXRoKVxuICAgICAgICAgID8gcmVzdHJpY3RQcm9ncmFtVG9QYXRoXG4gICAgICAgICAgOiBbcmVzdHJpY3RQcm9ncmFtVG9QYXRoXTtcblxuICAgICAgICBjb25zdCBmdWxsUmVzdHJpY3RlZFBhdGhzID0gcmVzdHJpY3RQcm9ncmFtVG9QYXRocy5tYXAoKGNvbGxlY3RvclBhdGgpID0+XG4gICAgICAgICAgcGF0aC5yZXNvbHZlKHByb2Nlc3MuY3dkKCksIGNvbGxlY3RvclBhdGgpXG4gICAgICAgICk7XG4gICAgICAgIGNvbnN0IHJlc3RyaWN0ZWRQcm9ncmFtUGF0aHMgPSBwcm9ncmFtUGF0aHMuZmlsdGVyKChwcm9ncmFtUGF0aCkgPT5cbiAgICAgICAgICBmdWxsUmVzdHJpY3RlZFBhdGhzLmluY2x1ZGVzKHByb2dyYW1QYXRoKVxuICAgICAgICApO1xuICAgICAgICBpZiAocmVzdHJpY3RlZFByb2dyYW1QYXRocy5sZW5ndGgpIHtcbiAgICAgICAgICByb290LnBhcnNlZENvbGxlY3Rpb25zID0gWy4uLmV4dHJhY3RDb2xsZWN0b3JzKHJlc3RyaWN0ZWRQcm9ncmFtUGF0aHMsIHRzQ29uZmlnKV07XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuO1xuICAgICAgfVxuXG4gICAgICByb290LnBhcnNlZENvbGxlY3Rpb25zID0gWy4uLmV4dHJhY3RDb2xsZWN0b3JzKHByb2dyYW1QYXRocywgdHNDb25maWcpXTtcbiAgICB9LFxuICAgIHRpdGxlOiBgRXh0cmFjdGluZyBjb2xsZWN0b3JzIGluICR7cm9vdC5jb25maWcucm9vdH1gLFxuICB9KSk7XG59XG4iXX0=