/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { EuiCodeBlock, EuiTabbedContent, EuiCopy, EuiButton, EuiModalBody, EuiModalHeader, EuiModalHeaderTitle, EuiModalFooter, EuiButtonEmpty, EuiCallOut } from '@elastic/eui';
import { ShardFailureTable } from './shard_failure_table';
export function ShardFailureModal(_ref) {
  var request = _ref.request,
      response = _ref.response,
      title = _ref.title,
      onClose = _ref.onClose;

  if (!response || !response._shards || !Array.isArray(response._shards.failures) || !request) {
    // this should never ever happen, but just in case
    return /*#__PURE__*/React.createElement(EuiCallOut, {
      title: "Sorry, there was an error",
      color: "danger",
      iconType: "alert"
    }, "The ShardFailureModal component received invalid properties");
  }

  var requestJSON = JSON.stringify(request, null, 2);
  var responseJSON = JSON.stringify(response, null, 2);
  var failures = response._shards.failures;
  var tabs = [{
    id: 'table',
    name: i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tabHeaderShardFailures', {
      defaultMessage: 'Shard failures',
      description: 'Name of the tab displaying shard failures'
    }),
    content: /*#__PURE__*/React.createElement(ShardFailureTable, {
      failures: failures
    })
  }, {
    id: 'json-request',
    name: i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tabHeaderRequest', {
      defaultMessage: 'Request',
      description: 'Name of the tab displaying the JSON request'
    }),
    content: /*#__PURE__*/React.createElement(EuiCodeBlock, {
      language: "json",
      isCopyable: true
    }, requestJSON)
  }, {
    id: 'json-response',
    name: i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tabHeaderResponse', {
      defaultMessage: 'Response',
      description: 'Name of the tab displaying the JSON response'
    }),
    content: /*#__PURE__*/React.createElement(EuiCodeBlock, {
      language: "json",
      isCopyable: true
    }, responseJSON)
  }];
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, title)), /*#__PURE__*/React.createElement(EuiModalBody, null, /*#__PURE__*/React.createElement(EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected"
  })), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiCopy, {
    textToCopy: responseJSON
  }, function (copy) {
    return /*#__PURE__*/React.createElement(EuiButtonEmpty, {
      onClick: copy
    }, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "data.search.searchSource.fetch.shardsFailedModal.copyToClipboard",
      defaultMessage: "Copy response to clipboard"
    }));
  }), /*#__PURE__*/React.createElement(EuiButton, {
    onClick: function onClick() {
      return onClose();
    },
    fill: true,
    "data-test-sub": "closeShardFailureModal"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "data.search.searchSource.fetch.shardsFailedModal.close",
    defaultMessage: "Close",
    description: "Closing the Modal"
  }))));
}