function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { i18n } from '@kbn/i18n';
import { KibanaContextProvider } from '../../../kibana_react/public'; // @ts-ignore

import { HomeApp } from './components/home_app';
import { getServices } from './kibana_services';
import './index.scss';
export var renderApp = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(element, coreStart, history) {
    var homeTitle, _getServices, featureCatalogue, chrome, directories, unlisten;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            homeTitle = i18n.translate('home.breadcrumbs.homeTitle', {
              defaultMessage: 'Home'
            });
            _getServices = getServices(), featureCatalogue = _getServices.featureCatalogue, chrome = _getServices.chrome; // all the directories could be get in "start" phase of plugin after all of the legacy plugins will be moved to a NP

            directories = featureCatalogue.get();
            chrome.setBreadcrumbs([{
              text: homeTitle
            }]);
            render( /*#__PURE__*/React.createElement(KibanaContextProvider, {
              services: _objectSpread({}, coreStart)
            }, /*#__PURE__*/React.createElement(HomeApp, {
              directories: directories
            })), element); // dispatch synthetic hash change event to update hash history objects
            // this is necessary because hash updates triggered by using popState won't trigger this event naturally.

            unlisten = history.listen(function () {
              window.dispatchEvent(new HashChangeEvent('hashchange'));
            });
            return _context.abrupt("return", function () {
              unmountComponentAtNode(element);
              unlisten();
            });

          case 7:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function renderApp(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();