function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent } from 'react';
import { EuiIcon, EuiInMemoryTable, EuiIconTip } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
// localized labels
var additionalInfoAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.additionalInfoAriaLabel', {
  defaultMessage: 'Additional field information'
});
var primaryTimeAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.primaryTimeAriaLabel', {
  defaultMessage: 'Primary time field'
});
var primaryTimeTooltip = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.primaryTimeTooltip', {
  defaultMessage: 'This field represents the time that events occurred.'
});
var multiTypeAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.multiTypeAria', {
  defaultMessage: 'Multiple type field'
});
var multiTypeTooltip = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.multiTypeTooltip', {
  defaultMessage: 'The type of this field changes across indices. It is unavailable for many analysis functions.'
});
var nameHeader = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.nameHeader', {
  defaultMessage: 'Name'
});
var typeHeader = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.typeHeader', {
  defaultMessage: 'Type'
});
var formatHeader = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.formatHeader', {
  defaultMessage: 'Format'
});
var searchableHeader = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.searchableHeader', {
  defaultMessage: 'Searchable'
});
var searchableDescription = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.searchableDescription', {
  defaultMessage: 'These fields can be used in the filter bar'
});
var isSearchableAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.isSearchableAria', {
  defaultMessage: 'Is searchable'
});
var aggregatableLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.aggregatableLabel', {
  defaultMessage: 'Aggregatable'
});
var aggregatableDescription = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.aggregatableDescription', {
  defaultMessage: 'These fields can be used in visualization aggregations'
});
var isAggregatableAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.isAggregatableAria', {
  defaultMessage: 'Is aggregatable'
});
var excludedLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.excludedLabel', {
  defaultMessage: 'Excluded'
});
var excludedDescription = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.excludedDescription', {
  defaultMessage: 'Fields that are excluded from _source when it is fetched'
});
var isExcludedAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.isExcludedAria', {
  defaultMessage: 'Is excluded'
});
var editLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.editLabel', {
  defaultMessage: 'Edit'
});
var editDescription = i18n.translate('indexPatternManagement.editIndexPattern.fields.table.editDescription', {
  defaultMessage: 'Edit'
});
export var Table = /*#__PURE__*/function (_PureComponent) {
  _inherits(Table, _PureComponent);

  var _super = _createSuper(Table);

  function Table() {
    _classCallCheck(this, Table);

    return _super.apply(this, arguments);
  }

  _createClass(Table, [{
    key: "renderBooleanTemplate",
    value: function renderBooleanTemplate(value, arialLabel) {
      return value ? /*#__PURE__*/React.createElement(EuiIcon, {
        type: "dot",
        color: "secondary",
        "aria-label": arialLabel
      }) : /*#__PURE__*/React.createElement("span", null);
    }
  }, {
    key: "renderFieldName",
    value: function renderFieldName(name, field) {
      var indexPattern = this.props.indexPattern;
      return /*#__PURE__*/React.createElement("span", null, name, field.info && field.info.length ? /*#__PURE__*/React.createElement("span", null, "\xA0", /*#__PURE__*/React.createElement(EuiIconTip, {
        type: "questionInCircle",
        color: "primary",
        "aria-label": additionalInfoAriaLabel,
        content: field.info.map(function (info, i) {
          return /*#__PURE__*/React.createElement("div", {
            key: i
          }, info);
        })
      })) : null, indexPattern.timeFieldName === name ? /*#__PURE__*/React.createElement("span", null, "\xA0", /*#__PURE__*/React.createElement(EuiIconTip, {
        type: "clock",
        color: "primary",
        "aria-label": primaryTimeAriaLabel,
        content: primaryTimeTooltip
      })) : null);
    }
  }, {
    key: "renderFieldType",
    value: function renderFieldType(type, isConflict) {
      return /*#__PURE__*/React.createElement("span", null, type, isConflict ? /*#__PURE__*/React.createElement("span", null, "\xA0", /*#__PURE__*/React.createElement(EuiIconTip, {
        type: "alert",
        color: "warning",
        "aria-label": multiTypeAriaLabel,
        content: multiTypeTooltip
      })) : '');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          items = _this$props.items,
          editField = _this$props.editField;
      var pagination = {
        initialPageSize: 10,
        pageSizeOptions: [5, 10, 25, 50]
      };
      var columns = [{
        field: 'displayName',
        name: nameHeader,
        dataType: 'string',
        sortable: true,
        render: function render(value, field) {
          return _this.renderFieldName(value, field);
        },
        width: '38%',
        'data-test-subj': 'indexedFieldName'
      }, {
        field: 'type',
        name: typeHeader,
        dataType: 'string',
        sortable: true,
        render: function render(value) {
          return _this.renderFieldType(value, value === 'conflict');
        },
        'data-test-subj': 'indexedFieldType'
      }, {
        field: 'format',
        name: formatHeader,
        dataType: 'string',
        sortable: true
      }, {
        field: 'searchable',
        name: searchableHeader,
        description: searchableDescription,
        dataType: 'boolean',
        sortable: true,
        render: function render(value) {
          return _this.renderBooleanTemplate(value, isSearchableAriaLabel);
        }
      }, {
        field: 'aggregatable',
        name: aggregatableLabel,
        description: aggregatableDescription,
        dataType: 'boolean',
        sortable: true,
        render: function render(value) {
          return _this.renderBooleanTemplate(value, isAggregatableAriaLabel);
        }
      }, {
        field: 'excluded',
        name: excludedLabel,
        description: excludedDescription,
        dataType: 'boolean',
        sortable: true,
        render: function render(value) {
          return _this.renderBooleanTemplate(value, isExcludedAriaLabel);
        }
      }, {
        name: '',
        actions: [{
          name: editLabel,
          description: editDescription,
          icon: 'pencil',
          onClick: editField,
          type: 'icon',
          'data-test-subj': 'editFieldFormat'
        }],
        width: '40px'
      }];
      return /*#__PURE__*/React.createElement(EuiInMemoryTable, {
        items: items,
        columns: columns,
        pagination: pagination,
        sorting: true
      });
    }
  }]);

  return Table;
}(PureComponent);