function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent } from 'react';
import { EuiFieldNumber, EuiFieldText, EuiFormRow, EuiSwitch, EuiCodeEditor } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
export var Field = /*#__PURE__*/function (_PureComponent) {
  _inherits(Field, _PureComponent);

  var _super = _createSuper(Field);

  function Field() {
    _classCallCheck(this, Field);

    return _super.apply(this, arguments);
  }

  _createClass(Field, [{
    key: "render",
    value: function render() {
      var name = this.props.name;
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        fullWidth: true,
        label: name
      }, this.renderField());
    }
  }, {
    key: "onCodeEditorChange",
    value: function onCodeEditorChange(targetValue) {
      var _this$props = this.props,
          name = _this$props.name,
          onChange = _this$props.onChange;
      var invalid = false;

      try {
        JSON.parse(targetValue);
      } catch (e) {
        invalid = true;
      }

      onChange(name, {
        value: targetValue,
        invalid: invalid
      });
    }
  }, {
    key: "onFieldChange",
    value: function onFieldChange(targetValue) {
      var _this$props2 = this.props,
          name = _this$props2.name,
          type = _this$props2.type,
          onChange = _this$props2.onChange;
      var newParsedValue = targetValue;
      var invalid = false;

      if (type === 'number') {
        try {
          newParsedValue = Number(newParsedValue);
        } catch (e) {
          invalid = true;
        }
      }

      onChange(name, {
        value: newParsedValue,
        invalid: invalid
      });
    }
  }, {
    key: "renderField",
    value: function renderField() {
      var _state$value,
          _this = this;

      var _this$props3 = this.props,
          type = _this$props3.type,
          name = _this$props3.name,
          state = _this$props3.state,
          disabled = _this$props3.disabled;
      var currentValue = (_state$value = state === null || state === void 0 ? void 0 : state.value) !== null && _state$value !== void 0 ? _state$value : this.props.value;

      switch (type) {
        case 'number':
          return /*#__PURE__*/React.createElement(EuiFieldNumber, {
            name: name,
            id: this.fieldId,
            value: currentValue,
            onChange: function onChange(e) {
              return _this.onFieldChange(e.target.value);
            },
            disabled: disabled,
            "data-test-subj": "savedObjects-editField-".concat(name)
          });

        case 'boolean':
          return /*#__PURE__*/React.createElement(EuiSwitch, {
            name: name,
            id: this.fieldId,
            label: !!currentValue ? /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "savedObjectsManagement.field.onLabel",
              defaultMessage: "On"
            }) : /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "savedObjectsManagement.field.offLabel",
              defaultMessage: "Off"
            }),
            checked: !!currentValue,
            onChange: function onChange(e) {
              return _this.onFieldChange(e.target.checked);
            },
            disabled: disabled,
            "data-test-subj": "savedObjects-editField-".concat(name)
          });

        case 'json':
        case 'array':
          return /*#__PURE__*/React.createElement("div", {
            "data-test-subj": "savedObjects-editField-".concat(name)
          }, /*#__PURE__*/React.createElement(EuiCodeEditor, {
            name: "savedObjects-editField-".concat(name, "-aceEditor"),
            mode: "json",
            theme: "textmate",
            value: currentValue,
            onChange: function onChange(value) {
              return _this.onCodeEditorChange(value);
            },
            width: "100%",
            height: "auto",
            minLines: 6,
            maxLines: 30,
            isReadOnly: disabled,
            setOptions: {
              showLineNumbers: true,
              tabSize: 2,
              useSoftTabs: true
            },
            editorProps: {
              $blockScrolling: Infinity
            },
            showGutter: true
          }));

        default:
          return /*#__PURE__*/React.createElement(EuiFieldText, {
            id: this.fieldId,
            name: name,
            value: currentValue,
            onChange: function onChange(e) {
              return _this.onFieldChange(e.target.value);
            },
            disabled: disabled,
            "data-test-subj": "savedObjects-editField-".concat(name)
          });
      }
    }
  }, {
    key: "fieldId",
    get: function get() {
      var name = this.props.name;
      return "savedObjects-editField-".concat(name);
    }
  }]);

  return Field;
}(PureComponent);