/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFormRow, EuiSelect } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { useMount } from 'react-use';
import { isCompatibleAggregation, useAvailableOptions, useFallbackMetric, useValidation } from './utils';
import { search } from '../../../../data/public';
var termsAggFilter = search.aggs.termsAggFilter;
var DEFAULT_VALUE = '_key';
var DEFAULT_OPTIONS = [{
  text: i18n.translate('visDefaultEditor.controls.orderAgg.alphabeticalLabel', {
    defaultMessage: 'Alphabetical'
  }),
  value: DEFAULT_VALUE
}];
var isCompatibleAgg = isCompatibleAggregation(termsAggFilter);

function OrderByParamEditor(_ref) {
  var agg = _ref.agg,
      value = _ref.value,
      showValidation = _ref.showValidation,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      setTouched = _ref.setTouched,
      metricAggs = _ref.metricAggs;
  var label = i18n.translate('visDefaultEditor.controls.orderAgg.orderByLabel', {
    defaultMessage: 'Order by'
  });
  var isValid = !!value;
  useValidation(setValidity, isValid);
  useMount(function () {
    // setup the initial value of orderBy
    if (!value) {
      var respAgg = {
        id: DEFAULT_VALUE
      };

      if (metricAggs) {
        respAgg = metricAggs.filter(isCompatibleAgg)[0] || respAgg;
      }

      setValue(respAgg.id);
    }
  });
  useFallbackMetric(setValue, termsAggFilter, metricAggs, value, DEFAULT_VALUE);
  var options = useAvailableOptions(termsAggFilter, metricAggs, DEFAULT_OPTIONS);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiSelect, {
    options: options,
    value: value,
    onChange: function onChange(ev) {
      return setValue(ev.target.value);
    },
    fullWidth: true,
    compressed: true,
    isInvalid: showValidation && !isValid,
    onBlur: setTouched,
    "data-test-subj": "visEditorOrderBy".concat(agg.id)
  }));
}

export { OrderByParamEditor };