function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { isFunction, omitBy, union } from 'lodash';
import { migrateAppState } from './migrate_app_state';
import { createStateContainer, syncState } from '../../../../kibana_utils/public';
var STATE_STORAGE_KEY = '_a';

function toObject(state) {
  return omitBy(state, function (value, key) {
    return key.charAt(0) === '$' || key.charAt(0) === '_' || isFunction(value);
  });
}

export function createVisualizeAppState(_ref) {
  var stateDefaults = _ref.stateDefaults,
      kbnUrlStateStorage = _ref.kbnUrlStateStorage;
  var urlState = kbnUrlStateStorage.get(STATE_STORAGE_KEY);
  var initialState = migrateAppState(_objectSpread(_objectSpread({}, stateDefaults), urlState));
  /*
    make sure url ('_a') matches initial state
    Initializing appState does two things - first it translates the defaults into AppState,
    second it updates appState based on the url (the url trumps the defaults). This means if
    we update the state format at all and want to handle BWC, we must not only migrate the
    data stored with saved vis, but also any old state in the url.
  */

  kbnUrlStateStorage.set(STATE_STORAGE_KEY, initialState, {
    replace: true
  });
  var stateContainer = createStateContainer(initialState, {
    set: function set(state) {
      return function (prop, value) {
        return _objectSpread(_objectSpread({}, state), {}, _defineProperty({}, prop, value));
      };
    },
    setVis: function setVis(state) {
      return function (vis) {
        return _objectSpread(_objectSpread({}, state), {}, {
          vis: _objectSpread(_objectSpread({}, state.vis), vis)
        });
      };
    },
    unlinkSavedSearch: function unlinkSavedSearch(state) {
      return function (_ref2) {
        var query = _ref2.query,
            _ref2$parentFilters = _ref2.parentFilters,
            parentFilters = _ref2$parentFilters === void 0 ? [] : _ref2$parentFilters;
        return _objectSpread(_objectSpread({}, state), {}, {
          query: query || state.query,
          filters: union(state.filters, parentFilters),
          linked: false
        });
      };
    },
    updateVisState: function updateVisState(state) {
      return function (newVisState) {
        return _objectSpread(_objectSpread({}, state), {}, {
          vis: toObject(newVisState)
        });
      };
    },
    updateSavedQuery: function updateSavedQuery(state) {
      return function (savedQueryId) {
        var updatedState = _objectSpread(_objectSpread({}, state), {}, {
          savedQuery: savedQueryId
        });

        if (!savedQueryId) {
          delete updatedState.savedQuery;
        }

        return updatedState;
      };
    }
  });

  var _syncState = syncState({
    storageKey: STATE_STORAGE_KEY,
    stateContainer: _objectSpread(_objectSpread({}, stateContainer), {}, {
      set: function set(state) {
        if (state) {
          // syncState utils requires to handle incoming "null" value
          stateContainer.set(state);
        }
      }
    }),
    stateStorage: kbnUrlStateStorage
  }),
      startStateSync = _syncState.start,
      stopStateSync = _syncState.stop; // start syncing the appState with the ('_a') url


  startStateSync();
  return {
    stateContainer: stateContainer,
    stopStateSync: stopStateSync
  };
}