function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { createSavedSearchesLoader } from '../../../../discover/public';
export var getVisualizationInstance = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref, opts) {
    var chrome, data, overlays, visualizations, createVisEmbeddableFromObject, savedObjects, savedVisualizations, toastNotifications, savedVis, serializedVis, vis, embeddableHandler, savedSearch;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            chrome = _ref.chrome, data = _ref.data, overlays = _ref.overlays, visualizations = _ref.visualizations, createVisEmbeddableFromObject = _ref.createVisEmbeddableFromObject, savedObjects = _ref.savedObjects, savedVisualizations = _ref.savedVisualizations, toastNotifications = _ref.toastNotifications;
            _context.next = 3;
            return savedVisualizations.get(opts);

          case 3:
            savedVis = _context.sent;

            if (typeof opts !== 'string') {
              savedVis.searchSourceFields = {
                index: opts === null || opts === void 0 ? void 0 : opts.indexPattern
              };
            }

            serializedVis = visualizations.convertToSerializedVis(savedVis);
            _context.next = 8;
            return visualizations.createVis(serializedVis.type, serializedVis);

          case 8:
            vis = _context.sent;

            if (!vis.type.setup) {
              _context.next = 18;
              break;
            }

            _context.prev = 10;
            _context.next = 13;
            return vis.type.setup(vis);

          case 13:
            vis = _context.sent;
            _context.next = 18;
            break;

          case 16:
            _context.prev = 16;
            _context.t0 = _context["catch"](10);

          case 18:
            _context.next = 20;
            return createVisEmbeddableFromObject(vis, {
              timeRange: data.query.timefilter.timefilter.getTime(),
              filters: data.query.filterManager.getFilters(),
              id: ''
            });

          case 20:
            embeddableHandler = _context.sent;
            embeddableHandler.getOutput$().subscribe(function (output) {
              if (output.error) {
                toastNotifications.addError(output.error, {
                  title: i18n.translate('visualize.error.title', {
                    defaultMessage: 'Visualization error'
                  })
                });
              }
            });

            if (!vis.data.savedSearchId) {
              _context.next = 26;
              break;
            }

            _context.next = 25;
            return createSavedSearchesLoader({
              savedObjectsClient: savedObjects.client,
              indexPatterns: data.indexPatterns,
              search: data.search,
              chrome: chrome,
              overlays: overlays
            }).get(vis.data.savedSearchId);

          case 25:
            savedSearch = _context.sent;

          case 26:
            return _context.abrupt("return", {
              vis: vis,
              savedVis: savedVis,
              savedSearch: savedSearch,
              embeddableHandler: embeddableHandler
            });

          case 27:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[10, 16]]);
  }));

  return function getVisualizationInstance(_x, _x2) {
    return _ref2.apply(this, arguments);
  };
}();