/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.settings.PyDebuggerSteppingConfigurableUi;
import com.jetbrains.python.debugger.settings.PySteppingFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerSettings
extends XDebuggerSettings<PyDebuggerSettings>
implements Getter<PyDebuggerSettings> {
    private boolean myLibrariesFilterEnabled;
    private boolean mySteppingFiltersEnabled;
    @NotNull
    private List<PySteppingFilter> mySteppingFilters;
    public static final String FILTERS_DIVIDER = ";";
    private boolean myWatchReturnValues = false;
    private boolean mySimplifiedView = true;
    private volatile PyDebugValue.ValuesPolicy myValuesPolicy = PyDebugValue.ValuesPolicy.ASYNC;
    private boolean myAlwaysDoSmartStepIntoEnabled = true;

    public PyDebuggerSettings() {
        super("python");
        this.mySteppingFilters = new SmartList();
    }

    public boolean isWatchReturnValues() {
        return this.myWatchReturnValues;
    }

    public void setWatchReturnValues(boolean watchReturnValues) {
        this.myWatchReturnValues = watchReturnValues;
    }

    public boolean isSimplifiedView() {
        return this.mySimplifiedView;
    }

    public void setSimplifiedView(boolean simplifiedView) {
        this.mySimplifiedView = simplifiedView;
    }

    public PyDebugValue.ValuesPolicy getValuesPolicy() {
        return this.myValuesPolicy;
    }

    public void setValuesPolicy(PyDebugValue.ValuesPolicy valuesPolicy) {
        this.myValuesPolicy = valuesPolicy;
    }

    public static PyDebuggerSettings getInstance() {
        return (PyDebuggerSettings)PyDebuggerSettings.getInstance(PyDebuggerSettings.class);
    }

    public boolean isLibrariesFilterEnabled() {
        return this.myLibrariesFilterEnabled;
    }

    public void setLibrariesFilterEnabled(boolean librariesFilterEnabled) {
        this.myLibrariesFilterEnabled = librariesFilterEnabled;
    }

    public boolean isSteppingFiltersEnabled() {
        return this.mySteppingFiltersEnabled;
    }

    public void setSteppingFiltersEnabled(boolean steppingFiltersEnabled) {
        this.mySteppingFiltersEnabled = steppingFiltersEnabled;
    }

    public void setAlwaysDoSmartStepIntoEnabled(boolean alwaysDoSmartStepIntoEnabled) {
        this.myAlwaysDoSmartStepIntoEnabled = alwaysDoSmartStepIntoEnabled;
    }

    public boolean isAlwaysDoSmartStepInto() {
        return this.myAlwaysDoSmartStepIntoEnabled;
    }

    @NotNull
    public List<PySteppingFilter> getSteppingFilters() {
        List<PySteppingFilter> list = this.mySteppingFilters;
        if (list == null) {
            PyDebuggerSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public String getSteppingFiltersForProject(@NotNull Project project) {
        if (project == null) {
            PyDebuggerSettings.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        for (PySteppingFilter filter : this.mySteppingFilters) {
            if (!filter.isEnabled()) continue;
            sb.append(filter.getAbsolutePlatformIndependentFilter(project)).append(FILTERS_DIVIDER);
        }
        String string = sb.toString();
        if (string == null) {
            PyDebuggerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setSteppingFilters(@NotNull List<PySteppingFilter> steppingFilters) {
        if (steppingFilters == null) {
            PyDebuggerSettings.$$$reportNull$$$0(3);
        }
        this.mySteppingFilters = steppingFilters;
    }

    @Nullable
    public PyDebuggerSettings getState() {
        return this;
    }

    public void loadState(@NotNull PyDebuggerSettings state2) {
        if (state2 == null) {
            PyDebuggerSettings.$$$reportNull$$$0(4);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state2), (Object)((Object)this));
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            PyDebuggerSettings.$$$reportNull$$$0(5);
        }
        return true;
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            PyDebuggerSettings.$$$reportNull$$$0(6);
        }
        if (category == DebuggerSettingsCategory.STEPPING) {
            List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"python.debug.configurable", (String)"Python", PyDebuggerSteppingConfigurableUi.class, (Getter)this));
            if (list == null) {
                PyDebuggerSettings.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PyDebuggerSettings.$$$reportNull$$$0(8);
        }
        return list;
    }

    public PyDebuggerSettings get() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/settings/PyDebuggerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "steppingFilters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSteppingFilters";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/settings/PyDebuggerSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSteppingFiltersForProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSteppingFiltersForProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSteppingFilters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

