/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySearchUtilBase {
    public static GlobalSearchScope excludeSdkTestsScope(Project project) {
        return PySearchUtilBase.excludeSdkTestScope(ProjectScope.getAllScope((Project)project));
    }

    @NotNull
    public static GlobalSearchScope excludeSdkTestScope(@NotNull GlobalSearchScope scope) {
        Sdk sdk;
        Project project;
        GlobalSearchScope exclude;
        if (scope == null) {
            PySearchUtilBase.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = (exclude = PySearchUtilBase.excludeSdkTestsScope(project = Objects.requireNonNull(scope.getProject()), sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk())) != null ? scope.intersectWith(exclude) : scope;
        if (globalSearchScope == null) {
            PySearchUtilBase.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    public static GlobalSearchScope excludeSdkTestsScope(PsiElement anchor) {
        GlobalSearchScope excludeScope;
        Sdk sdk;
        Project project = anchor.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor);
        if (module != null && (sdk = PythonSdkUtil.findPythonSdk(module)) != null && (excludeScope = PySearchUtilBase.excludeSdkTestsScope(project, sdk)) != null) {
            return GlobalSearchScope.allScope((Project)project).intersectWith(excludeScope);
        }
        return PySearchUtilBase.excludeSdkTestsScope(project);
    }

    @Nullable
    private static GlobalSearchScope excludeSdkTestsScope(Project project, Sdk sdk) {
        if (sdk != null && PythonSdkUtil.isPythonSdk(sdk)) {
            ArrayList<VirtualFile> excludedDirs = new ArrayList<VirtualFile>();
            VirtualFile libDir = PySearchUtilBase.findLibDir(sdk);
            if (libDir != null) {
                excludedDirs.addAll(PySearchUtilBase.findTestDirs(libDir, "test", "bsddb/test", "ctypes/test", "distutils/tests", "email/test", "importlib/test", "json/tests", "lib2to3/tests", "sqlite3/test", "tkinter/test", "idlelib/testcode.py"));
            }
            excludedDirs.addAll(Arrays.stream(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)).filter(file -> PyTypeShed.INSTANCE.isInside((VirtualFile)file) && PyTypeShed.INSTANCE.isInThirdPartyLibraries((VirtualFile)file)).collect(Collectors.toList()));
            if (!excludedDirs.isEmpty()) {
                GlobalSearchScope scope = PySearchUtilBase.buildUnionScope(project, excludedDirs);
                return GlobalSearchScope.notScope((GlobalSearchScope)scope);
            }
        }
        return null;
    }

    private static GlobalSearchScope buildUnionScope(Project project, List<VirtualFile> testDirs) {
        GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)testDirs.get(0), (boolean)true);
        for (int i = 1; i < testDirs.size(); ++i) {
            scope = scope.union((SearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)testDirs.get(i), (boolean)true));
        }
        return scope;
    }

    private static List<VirtualFile> findTestDirs(VirtualFile baseDir, String ... relativePaths) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : relativePaths) {
            VirtualFile child = baseDir.findFileByRelativePath(path);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    @Nullable
    public static VirtualFile findLibDir(Sdk sdk) {
        return PySearchUtilBase.findLibDir(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
    }

    public static VirtualFile findVirtualEnvLibDir(Sdk sdk) {
        File root;
        VirtualFile[] classVFiles = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        String homePath = sdk.getHomePath();
        if (homePath != null && (root = PythonSdkUtil.getVirtualEnvRoot(homePath)) != null) {
            File versionRoot;
            File libRoot = new File(root, "lib");
            Object[] versionRoots = libRoot.listFiles();
            if (versionRoots != null && !SystemInfo.isWindows && (versionRoot = (File)ContainerUtil.find((Object[])versionRoots, file -> file.isDirectory() && file.getName().startsWith("python"))) != null) {
                libRoot = versionRoot;
            }
            if (classVFiles.length == 0) {
                return LocalFileSystem.getInstance().findFileByIoFile(libRoot);
            }
            String libRootPath = libRoot.getPath();
            for (VirtualFile file2 : classVFiles) {
                if (FileUtil.pathsEqual((String)file2.getPath(), (String)libRootPath)) {
                    return file2;
                }
                VirtualFile parent = file2.getParent();
                if (!"site-packages".equals(file2.getName()) || !FileUtil.pathsEqual((String)parent.getPath(), (String)libRootPath)) continue;
                return parent;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findLibDir(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!file.isValid()) continue;
            if ((file.findChild("__future__.py") != null || file.findChild("__future__.pyc") != null) && file.findChild("xml") != null && file.findChild("email") != null) {
                return file;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() || !file.getName().equals("Lib")) continue;
            return file;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/search/PySearchUtilBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/search/PySearchUtilBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeSdkTestScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "excludeSdkTestScope";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

