/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JythonSdkFlavor
extends PythonSdkFlavor {
    private static final Pattern VERSION_RE = Pattern.compile("(Jython \\S+)( on .*)?");
    private static final String JYTHONPATH = "JYTHONPATH";
    private static final String PYTHON_PATH_PREFIX = "-Dpython.path=";

    private JythonSdkFlavor() {
    }

    public static JythonSdkFlavor getInstance() {
        return (JythonSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(JythonSdkFlavor.class);
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            JythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)file.getName())).startsWith("jython");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            JythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE);
    }

    @Override
    public String getVersionOption() {
        return "--version";
    }

    @Override
    public void initPythonPath(GeneralCommandLine cmd, boolean passParentEnvs, Collection<String> path) {
        this.initPythonPath(path, passParentEnvs, cmd.getEnvironment());
        ParamsGroup paramGroup = cmd.getParametersList().getParamsGroup("Exe Options");
        assert (paramGroup != null);
        for (String param : paramGroup.getParameters()) {
            if (!param.startsWith(PYTHON_PATH_PREFIX)) continue;
            return;
        }
        paramGroup.addParameter(JythonSdkFlavor.getPythonPathCmdLineArgument(path));
    }

    @Override
    public void initPythonPath(Collection<String> path, boolean passParentEnvs, Map<String, String> env) {
        if (passParentEnvs) {
            path = PythonEnvUtil.appendSystemEnvPaths(path, JYTHONPATH);
        }
        String jythonPath = StringUtil.join(path, (String)File.pathSeparator);
        PythonEnvUtil.addToEnv(JYTHONPATH, jythonPath, env);
    }

    @Override
    @NotNull
    public String getName() {
        return "Jython";
    }

    public static String getPythonPathCmdLineArgument(Collection<String> path) {
        return PYTHON_PATH_PREFIX + StringUtil.join(PythonEnvUtil.appendSystemEnvPaths(path, JYTHONPATH), (String)File.pathSeparator);
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Jython;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/flavors/JythonSdkFlavor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSdkPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersionStringFromOutput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

