/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.project.ProjectBundle;

public class FacetLoadingErrorDescription
extends ConfigurationErrorDescription {
    private final InvalidFacet myFacet;

    public FacetLoadingErrorDescription(InvalidFacet facet) {
        super(facet.getName() + " (" + facet.getModule().getName() + ")", facet.getErrorMessage(), new ConfigurationErrorType(ProjectBundle.message((String)"element.kind.name.facet", (Object[])new Object[0]), true));
        this.myFacet = facet;
    }

    @Override
    public String getIgnoreConfirmationMessage() {
        return ProjectBundle.message((String)"confirmation.message.would.you.like.to.ignore.facet", (Object[])new Object[]{this.myFacet.getName(), this.myFacet.getModule().getName()});
    }

    @Override
    public void ignoreInvalidElement() {
        InvalidFacetManager.getInstance(this.myFacet.getModule().getProject()).setIgnored(this.myFacet, true);
    }

    @Override
    public boolean isValid() {
        return !this.myFacet.isDisposed();
    }
}

