/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindInProjectSearchEngine;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class IdeaIndexBasedFindInProjectSearchEngine
implements FindInProjectSearchEngine {
    @NotNull
    public FindInProjectSearchEngine.FindInProjectSearcher createSearcher(@NotNull FindModel findModel, @NotNull Project project) {
        if (findModel == null) {
            IdeaIndexBasedFindInProjectSearchEngine.$$$reportNull$$$0(0);
        }
        if (project == null) {
            IdeaIndexBasedFindInProjectSearchEngine.$$$reportNull$$$0(1);
        }
        return new MyFindInProjectSearcher(project, findModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "findModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/find/impl/IdeaIndexBasedFindInProjectSearchEngine";
        objectArray[2] = "createSearcher";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyFindInProjectSearcher
    implements FindInProjectSearchEngine.FindInProjectSearcher {
        @NotNull
        private final ProjectFileIndex myFileIndex;
        @NotNull
        private final FileBasedIndexImpl myFileBasedIndex;
        @NotNull
        private final Project myProject;
        @NotNull
        private final FindModel myFindModel;
        private final boolean myHasTrigrams;
        private final String myStringToFindInIndices;

        MyFindInProjectSearcher(@NotNull Project project, @NotNull FindModel findModel) {
            if (project == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFindModel = findModel;
            this.myFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
            this.myFileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            String stringToFind = findModel.getStringToFind();
            if (findModel.isRegularExpressions()) {
                stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, project);
            }
            this.myStringToFindInIndices = stringToFind;
            this.myHasTrigrams = MyFindInProjectSearcher.hasTrigrams(this.myStringToFindInIndices);
        }

        @NotNull
        public Collection<VirtualFile> searchForOccurrences() {
            String stringToFind = MyFindInProjectSearcher.getStringToFindInIndexes(this.myFindModel, this.myProject);
            if (stringToFind.isEmpty() || DumbService.getInstance((Project)this.myProject).isDumb() && !FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
                Set<VirtualFile> set = Collections.emptySet();
                if (set == null) {
                    MyFindInProjectSearcher.$$$reportNull$$$0(2);
                }
                return set;
            }
            GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel), (Project)this.myProject);
            IntOpenHashSet keys2 = new IntOpenHashSet();
            TrigramBuilder.processTrigrams((CharSequence)stringToFind, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor((IntSet)keys2){
                final /* synthetic */ IntSet val$keys;
                {
                    this.val$keys = intSet;
                }

                public boolean test(int value2) {
                    this.val$keys.add(value2);
                    return true;
                }
            });
            if (!keys2.isEmpty()) {
                ArrayList hits = new ArrayList();
                FileBasedIndex.getInstance().ignoreDumbMode(() -> MyFindInProjectSearcher.lambda$searchForOccurrences$0((IntSet)keys2, hits, scope), DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE);
                Collection<VirtualFile> collection = Collections.unmodifiableCollection(hits);
                if (collection == null) {
                    MyFindInProjectSearcher.$$$reportNull$$$0(3);
                }
                return collection;
            }
            HashSet resultFiles = new HashSet();
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)this.myProject);
            helper.processCandidateFilesForText(scope, (short)255, this.myFindModel.isCaseSensitive(), stringToFind, file2 -> {
                ContainerUtil.addIfNotNull((Collection)resultFiles, (Object)file2);
                return true;
            });
            CacheManager cacheManager = CacheManager.getInstance(this.myProject);
            VirtualFile[] filesWithWord = cacheManager.getVirtualFilesWithWord(stringToFind, (short)255, scope, this.myFindModel.isCaseSensitive());
            Collections.addAll(resultFiles, filesWithWord);
            Collection<VirtualFile> collection = Collections.unmodifiableCollection(resultFiles);
            if (collection == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(4);
            }
            return collection;
        }

        public boolean isReliable() {
            if (DumbService.isDumb((Project)this.myProject)) {
                return false;
            }
            if (this.myFindModel.getCustomScope() instanceof LocalSearchScope) {
                return false;
            }
            if (this.myHasTrigrams) {
                return true;
            }
            return this.myFindModel.isWholeWordsOnly() && this.myStringToFindInIndices.indexOf(36) < 0 && !StringUtil.getWordsIn((String)this.myStringToFindInIndices).isEmpty();
        }

        public boolean isCovered(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(5);
            }
            return this.myHasTrigrams && this.isCoveredByIndex(file2) && (this.myFileIndex.isInContent(file2) || this.myFileIndex.isInLibrary(file2));
        }

        private boolean isCoveredByIndex(@NotNull VirtualFile file2) {
            FileType fileType;
            if (file2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(6);
            }
            return TrigramIndex.isIndexable(fileType = file2.getFileType()) && this.myFileBasedIndex.isIndexingCandidate(file2, TrigramIndex.INDEX_ID);
        }

        private static boolean hasTrigrams(@NotNull String text) {
            if (text == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(7);
            }
            return !TrigramBuilder.processTrigrams((CharSequence)text, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor(){

                public boolean test(int value2) {
                    return false;
                }
            });
        }

        @NotNull
        private static String getStringToFindInIndexes(@NotNull FindModel findModel, @NotNull Project project) {
            if (findModel == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(8);
            }
            if (project == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(9);
            }
            String stringToFind = findModel.getStringToFind();
            if (findModel.isRegularExpressions()) {
                stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, project);
            }
            String string = stringToFind;
            if (string == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void lambda$searchForOccurrences$0(IntSet keys2, List hits, GlobalSearchScope scope) {
            FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, (Set)keys2, Processors.cancelableCollectProcessor((Collection)hits), scope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/IdeaIndexBasedFindInProjectSearchEngine$MyFindInProjectSearcher";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/IdeaIndexBasedFindInProjectSearchEngine$MyFindInProjectSearcher";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "searchForOccurrences";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringToFindInIndexes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isCovered";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isCoveredByIndex";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "hasTrigrams";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getStringToFindInIndexes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

