/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.tree.project.ProjectFileNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePaneSelectInTarget
extends ProjectViewSelectInTarget {
    public ScopePaneSelectInTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.getScope();
    }

    @Override
    public boolean canSelect(PsiFileSystemItem fileSystemItem) {
        if (!(fileSystemItem instanceof PsiFile)) {
            return false;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)fileSystemItem);
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        AreaInstance area = ProjectFileNode.findArea(file2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file2), this.myProject);
        if (area == null) {
            return false;
        }
        return this.getContainingFilter((PsiFile)fileSystemItem) != null;
    }

    @Nullable
    private NamedScopeFilter getContainingFilter(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        ScopeViewPane pane2 = this.getScopeViewPane();
        if (pane2 == null) {
            return null;
        }
        for (NamedScopeFilter filter2 : pane2.getFilters()) {
            if (!filter2.accept(file2.getVirtualFile())) continue;
            return filter2;
        }
        return null;
    }

    @Override
    public void select(PsiElement element2, boolean requestFocus) {
        if (this.getSubId() == null) {
            NamedScopeFilter filter2 = this.getContainingFilter(element2.getContainingFile());
            if (filter2 == null) {
                return;
            }
            this.setSubId(filter2.toString());
        }
        super.select(element2, requestFocus);
    }

    public String getMinorViewId() {
        return "Scope";
    }

    public float getWeight() {
        return 6.5f;
    }

    @Override
    public boolean isSubIdSelectable(@NotNull String subId, @NotNull SelectInContext context) {
        PsiFileSystemItem file2;
        if (subId == null) {
            ScopePaneSelectInTarget.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScopePaneSelectInTarget.$$$reportNull$$$0(1);
        }
        if (!((file2 = this.getContextPsiFile(context)) instanceof PsiFile)) {
            return false;
        }
        ScopeViewPane pane2 = this.getScopeViewPane();
        NamedScopeFilter filter2 = pane2 == null ? null : pane2.getFilter(subId);
        return filter2 != null && filter2.accept(file2.getVirtualFile());
    }

    private ScopeViewPane getScopeViewPane() {
        ProjectView view = ProjectView.getInstance(this.myProject);
        AbstractProjectViewPane pane2 = view == null ? null : view.getProjectViewPaneById("Scope");
        return pane2 instanceof ScopeViewPane ? (ScopeViewPane)pane2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "subId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/scopeView/ScopePaneSelectInTarget";
        objectArray[2] = "isSubIdSelectable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

