/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.ImageDuplicateResultsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.io.DigestUtil;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ShowImageDuplicatesAction
extends AnAction {
    private static final List<String> IMAGE_EXTENSIONS = Arrays.asList("png", "jpg", "jpeg", "gif", "tiff", "bmp");

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowImageDuplicatesAction.$$$reportNull$$$0(0);
        }
        Project project = ShowImageDuplicatesAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ShowImageDuplicatesAction.collectAndShowDuplicates(project), "Gathering Images", true, project);
    }

    private static void collectAndShowDuplicates(Project project) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && !indicator.isCanceled()) {
            indicator.setText("Collecting project images...");
            indicator.setIndeterminate(false);
            ArrayList<VirtualFile> images = new ArrayList<VirtualFile>();
            for (String ext : IMAGE_EXTENSIONS) {
                images.addAll((Collection)ReadAction.compute(() -> FilenameIndex.getAllFilesByExt((Project)project, (String)ext)));
            }
            HashMap<Long, Set<VirtualFile>> duplicates = new HashMap<Long, Set<VirtualFile>>();
            HashMap all = new HashMap();
            for (int i2 = 0; i2 < images.size(); ++i2) {
                indicator.setFraction((double)(i2 + 1) / (double)images.size());
                VirtualFile file2 = (VirtualFile)images.get(i2);
                ReadAction.run(() -> {
                    if (!(file2.getFileSystem() instanceof LocalFileSystem)) {
                        return;
                    }
                    long length = file2.getLength();
                    if (all.containsKey(length)) {
                        if (!duplicates.containsKey(length)) {
                            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
                            files2.add((VirtualFile)all.get(length));
                            duplicates.put(length, files2);
                        }
                        ((Set)duplicates.get(length)).add(file2);
                    } else {
                        all.put(length, file2);
                    }
                });
                indicator.checkCanceled();
            }
            ShowImageDuplicatesAction.showResults(project, images, duplicates);
        }
    }

    private static void showResults(Project project, List<VirtualFile> images, Map<Long, Set<VirtualFile>> duplicates) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null || indicator.isCanceled()) {
            return;
        }
        indicator.setText("MD5 check");
        int count = duplicates.values().stream().mapToInt(Set::size).sum();
        HashMap realDuplicates = new HashMap();
        int seek = 0;
        for (Set<VirtualFile> files2 : duplicates.values()) {
            for (VirtualFile file2 : files2) {
                indicator.setFraction((double)(++seek) / (double)count);
                try {
                    ReadAction.run(() -> {
                        String md5 = ShowImageDuplicatesAction.getMD5Checksum(file2);
                        realDuplicates.computeIfAbsent(md5, k -> new HashSet()).add(file2);
                    });
                }
                catch (Exception exception) {}
            }
        }
        count = 0;
        for (String key : new ArrayList(realDuplicates.keySet())) {
            int size = ((Set)realDuplicates.get(key)).size();
            if (size == 1) {
                realDuplicates.remove(key);
                continue;
            }
            count += size;
        }
        ApplicationManager.getApplication().invokeLater(() -> new ImageDuplicateResultsDialog(project, images, realDuplicates).show());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowImageDuplicatesAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(ShowImageDuplicatesAction.getEventProject((AnActionEvent)e) != null);
    }

    private static byte[] createChecksum(VirtualFile file2) throws Exception {
        byte[] buffer = new byte[1024];
        MessageDigest md5 = DigestUtil.md5();
        try (InputStream fis = file2.getInputStream();){
            int read;
            while ((read = fis.read(buffer)) > 0) {
                md5.update(buffer, 0, read);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
    }

    private static String getMD5Checksum(VirtualFile fis) throws Exception {
        byte[] bytes = ShowImageDuplicatesAction.createChecksum(fis);
        StringBuilder md5 = new StringBuilder();
        for (byte b : bytes) {
            md5.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return md5.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/ShowImageDuplicatesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

