/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskNode
extends ExternalSystemNode<TaskData> {
    private final TaskData myTaskData;
    private String moduleOwnerName;

    public TaskNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DataNode<TaskData> dataNode) {
        if (externalProjectsView == null) {
            TaskNode.$$$reportNull$$$0(0);
        }
        if (dataNode == null) {
            TaskNode.$$$reportNull$$$0(1);
        }
        super(externalProjectsView, null, dataNode);
        this.myTaskData = (TaskData)dataNode.getData();
        DataNode parent = ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.MODULE);
        if (parent == null) {
            parent = ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.PROJECT);
        }
        if (parent != null && parent.getData() instanceof Named) {
            this.moduleOwnerName = ((Named)parent.getData()).getInternalName();
        }
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            TaskNode.$$$reportNull$$$0(2);
        }
        super.update(presentation2);
        presentation2.setIcon(this.getUiAware().getTaskIcon());
        String shortcutHint = StringUtil.nullize((String)this.getShortcutsManager().getDescription(this.myTaskData.getLinkedExternalProjectPath(), this.myTaskData.getName()));
        String activatorHint = StringUtil.nullize((String)this.getTaskActivator().getDescription(this.myTaskData.getOwner(), this.myTaskData.getLinkedExternalProjectPath(), this.myTaskData.getName()));
        String hint = shortcutHint == null ? activatorHint : (activatorHint == null ? shortcutHint : shortcutHint + ", " + activatorHint);
        this.setNameAndTooltip(this.getName(), this.myTaskData.getDescription(), hint);
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        return !this.myTaskData.isInherited() || this.getExternalProjectsView().showInheritedTasks();
    }

    public boolean isTest() {
        return this.myTaskData.isTest();
    }

    public String getModuleOwnerName() {
        return this.moduleOwnerName;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.TaskMenu";
    }

    @Override
    @Nullable
    protected String getActionId() {
        return "ExternalSystem.RunTask";
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/view/TaskNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

