/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenAdapter;
import com.apple.eawt.FullScreenListener;
import com.apple.eawt.FullScreenUtilities;
import com.intellij.ide.ActiveWindowsWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class MacMainFrameDecorator
extends IdeFrameDecorator {
    public static final String FULL_SCREEN = "Idea.Is.In.FullScreen.Mode.Now";
    private static Method requestToggleFullScreenMethod;
    private static Method enterFullScreenMethod;
    private static Method leaveFullScreenMethod;
    private final FullScreenQueue myFullScreenQueue;
    private final EventDispatcher<FSListener> myDispatcher;
    private boolean myInFullScreen;

    private void enterFullScreen() {
        this.myInFullScreen = true;
        this.storeFullScreenStateIfNeeded();
        this.myFullScreenQueue.runFromQueue();
    }

    private void exitFullScreen() {
        this.myInFullScreen = false;
        this.storeFullScreenStateIfNeeded();
        JRootPane rootPane = this.myFrame.getRootPane();
        if (rootPane != null) {
            rootPane.putClientProperty(FULL_SCREEN, null);
        }
        this.myFullScreenQueue.runFromQueue();
    }

    private void storeFullScreenStateIfNeeded() {
        this.myFrame.doLayout();
    }

    public MacMainFrameDecorator(@NotNull JFrame frame, final @NotNull Disposable parentDisposable) {
        if (frame == null) {
            MacMainFrameDecorator.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            MacMainFrameDecorator.$$$reportNull$$$0(1);
        }
        super(frame);
        this.myFullScreenQueue = new FullScreenQueue();
        this.myDispatcher = EventDispatcher.create(FSListener.class);
        if (leaveFullScreenMethod != null || requestToggleFullScreenMethod != null) {
            FullScreenUtilities.setWindowCanFullScreen((Window)frame, (boolean)true);
            FullScreenUtilities.addFullScreenListenerTo((Window)frame, (FullScreenListener)new FullScreenListener(){

                public void windowEnteringFullScreen(AppEvent.FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowEnteringFullScreen(event);
                }

                public void windowEnteredFullScreen(AppEvent.FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowEnteredFullScreen(event);
                }

                public void windowExitingFullScreen(AppEvent.FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowExitingFullScreen(event);
                }

                public void windowExitedFullScreen(AppEvent.FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowExitedFullScreen(event);
                }
            });
            this.myDispatcher.addListener((EventListener)new FSAdapter(){

                public void windowEnteringFullScreen(AppEvent.FullScreenEvent event) {
                    JRootPane rootPane = MacMainFrameDecorator.this.myFrame.getRootPane();
                    if (rootPane != null && rootPane.getBorder() != null && Registry.is((String)"ide.mac.transparentTitleBarAppearance")) {
                        rootPane.setBorder(null);
                    }
                }

                public void windowEnteredFullScreen(AppEvent.FullScreenEvent event) {
                    JRootPane rootPane = MacMainFrameDecorator.this.myFrame.getRootPane();
                    if (rootPane != null) {
                        rootPane.putClientProperty(MacMainFrameDecorator.FULL_SCREEN, Boolean.TRUE);
                    }
                    MacMainFrameDecorator.this.enterFullScreen();
                    MacMainFrameDecorator.this.myFrame.validate();
                }

                public void windowExitedFullScreen(AppEvent.FullScreenEvent event) {
                    JRootPane rootPane = MacMainFrameDecorator.this.myFrame.getRootPane();
                    if (rootPane instanceof IdeRootPane && Registry.is((String)"ide.mac.transparentTitleBarAppearance")) {
                        IdeRootPane ideRootPane = (IdeRootPane)rootPane;
                        UIUtil.setCustomTitleBar((Window)MacMainFrameDecorator.this.myFrame, (JRootPane)ideRootPane, runnable2 -> Disposer.register((Disposable)parentDisposable, () -> runnable2.run()));
                    }
                    MacMainFrameDecorator.this.exitFullScreen();
                    ActiveWindowsWatcher.addActiveWindow(MacMainFrameDecorator.this.myFrame);
                    MacMainFrameDecorator.this.myFrame.validate();
                }
            });
        }
    }

    @Override
    public boolean isInFullScreen() {
        return this.myInFullScreen;
    }

    @Override
    @NotNull
    public Promise<Boolean> toggleFullScreen(boolean state) {
        if (this.myInFullScreen == state) {
            Promise promise = Promises.resolvedPromise((Object)state);
            if (promise == null) {
                MacMainFrameDecorator.$$$reportNull$$$0(2);
            }
            return promise;
        }
        final AsyncPromise promise = new AsyncPromise();
        this.myDispatcher.addListener((EventListener)new FSAdapter(){

            public void windowExitedFullScreen(AppEvent.FullScreenEvent event) {
                promise.setResult((Object)false);
                MacMainFrameDecorator.this.myDispatcher.removeListener((EventListener)this);
            }

            public void windowEnteredFullScreen(AppEvent.FullScreenEvent event) {
                promise.setResult((Object)true);
                MacMainFrameDecorator.this.myDispatcher.removeListener((EventListener)this);
            }
        });
        if (requestToggleFullScreenMethod != null) {
            this.myFullScreenQueue.runOrEnqueue(() -> this.invokeAppMethod(requestToggleFullScreenMethod));
        } else if (state) {
            this.myFullScreenQueue.runOrEnqueue(() -> this.invokeAppMethod(enterFullScreenMethod));
        } else {
            this.myFullScreenQueue.runOrEnqueue(() -> this.invokeAppMethod(leaveFullScreenMethod));
        }
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            MacMainFrameDecorator.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    private void invokeAppMethod(Method method2) {
        try {
            method2.invoke((Object)Application.getApplication(), this.myFrame);
        }
        catch (Exception e) {
            Logger.getInstance(MacMainFrameDecorator.class).warn((Throwable)e);
        }
    }

    static {
        try {
            Class.forName("com.apple.eawt.FullScreenUtilities");
            try {
                enterFullScreenMethod = Application.class.getMethod("requestEnterFullScreen", Window.class);
                leaveFullScreenMethod = Application.class.getMethod("requestLeaveFullScreen", Window.class);
            }
            catch (NoSuchMethodException e) {
                requestToggleFullScreenMethod = Application.class.getMethod("requestToggleFullScreen", Window.class);
            }
        }
        catch (Exception e) {
            Logger.getInstance(MacMainFrameDecorator.class).debug((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MacMainFrameDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MacMainFrameDecorator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleFullScreen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FullScreenQueue {
        private final LinkedList<Runnable> myQueue = new LinkedList();
        private boolean myWaitingForAppKit = false;

        private FullScreenQueue() {
        }

        synchronized void runOrEnqueue(Runnable runnable2) {
            if (this.myWaitingForAppKit) {
                this.myQueue.add(runnable2);
            } else {
                ApplicationManager.getApplication().invokeLater(runnable2);
                this.myWaitingForAppKit = true;
            }
        }

        synchronized void runFromQueue() {
            if (!this.myQueue.isEmpty()) {
                this.myQueue.remove().run();
                this.myWaitingForAppKit = true;
            } else {
                this.myWaitingForAppKit = false;
            }
        }
    }

    private static class FSAdapter
    extends FullScreenAdapter
    implements FSListener {
        private FSAdapter() {
        }
    }

    private static interface FSListener
    extends FullScreenListener,
    EventListener {
    }
}

