/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.MouseWheelSmoothScroll;
import com.intellij.util.ui.SmoothScrollUtil;
import com.intellij.util.ui.TouchScrollUtil;
import java.awt.event.MouseWheelEvent;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TouchScroll {
    private final MouseWheelSmoothScroll.InertialAnimator horizontal;
    private final MouseWheelSmoothScroll.InertialAnimator vertical;
    private final FlingManager horizontalFling;
    private final FlingManager verticalFling;
    @NotNull
    private final Supplier<Boolean> myScrollEnabled;

    public static TouchScroll create() {
        return TouchScroll.create(() -> true);
    }

    public static TouchScroll create(@NotNull Supplier<Boolean> isScrollEnabled) {
        if (isScrollEnabled == null) {
            TouchScroll.$$$reportNull$$$0(0);
        }
        return new TouchScroll(isScrollEnabled);
    }

    private TouchScroll(@NotNull Supplier<Boolean> isEnabledChecker) {
        if (isEnabledChecker == null) {
            TouchScroll.$$$reportNull$$$0(1);
        }
        this.horizontal = new MouseWheelSmoothScroll.InertialAnimator();
        this.vertical = new MouseWheelSmoothScroll.InertialAnimator();
        this.horizontalFling = new FlingManager();
        this.verticalFling = new FlingManager();
        this.myScrollEnabled = Objects.requireNonNull(isEnabledChecker);
    }

    public void processMouseWheelEvent(@NotNull MouseWheelEvent e, @Nullable Consumer<MouseWheelEvent> alternative) {
        JScrollBar bar;
        if (e == null) {
            TouchScroll.$$$reportNull$$$0(2);
        }
        JScrollBar jScrollBar = bar = this.myScrollEnabled.get() == false ? null : SmoothScrollUtil.getEventScrollBar(e);
        if (bar == null) {
            if (alternative != null) {
                alternative.accept(e);
            }
            return;
        }
        if (TouchScrollUtil.isBegin(e)) {
            this.verticalFling.registerBegin();
            this.horizontalFling.registerBegin();
        } else if (TouchScrollUtil.isUpdate(e)) {
            int value = bar.getValue();
            int delta = (int)TouchScrollUtil.getDelta(e);
            bar.setValue(value + delta);
            FlingManager fling = SmoothScrollUtil.isHorizontalScroll(e) ? this.horizontalFling : this.verticalFling;
            fling.registerUpdate(delta);
        } else if (TouchScrollUtil.isEnd(e)) {
            this.verticalFling.start(SmoothScrollUtil.getEventVerticalScrollBar(e), this.vertical);
            this.horizontalFling.start(SmoothScrollUtil.getEventHorizontalScrollBar(e), this.horizontal);
        }
        e.consume();
    }

    private static Predicate<Integer> shouldStop(JScrollBar bar) {
        return v -> v - bar.getValue() != 0 || !bar.isShowing();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isScrollEnabled";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isEnabledChecker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/TouchScroll";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processMouseWheelEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum TouchAnimationSettings implements MouseWheelSmoothScroll.AnimationSettings
    {
        SETTINGS{
            private MouseWheelSmoothScroll.Easing cubicEaseOut;

            @Override
            public double getDuration() {
                return Math.max(Math.abs(Registry.doubleValue((String)"idea.inertial.smooth.scrolling.touch.duration")), 0.0);
            }

            @Override
            @NotNull
            public MouseWheelSmoothScroll.Easing getEasing() {
                if (this.cubicEaseOut == null) {
                    this.cubicEaseOut = new MouseWheelSmoothScroll.CubicBezierEasing(0.215, 0.61, 0.355, 1.0, 2000);
                }
                MouseWheelSmoothScroll.Easing easing = this.cubicEaseOut;
                if (easing == null) {
                    1.$$$reportNull$$$0(0);
                }
                return easing;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/TouchScroll$TouchAnimationSettings$1", "getEasing"));
            }
        };

    }

    private static class FlingManager {
        private long beginTime = 0L;
        private int lastDelta = 0;

        private FlingManager() {
        }

        public void registerBegin() {
            this.beginTime = System.currentTimeMillis();
            this.lastDelta = 0;
        }

        public void registerUpdate(int delta) {
            this.beginTime = 0L;
            this.lastDelta = delta;
        }

        private static int getPixelThreshold() {
            return Registry.intValue((String)"idea.inertial.touch.fling.pixelThreshold");
        }

        private static int getFlingMultiplier() {
            return Registry.intValue((String)"idea.inertial.touch.fling.multiplier");
        }

        private static int getFlingInterruptLag() {
            return Registry.intValue((String)"idea.inertial.touch.fling.interruptLag");
        }

        public boolean shouldStart() {
            return Math.abs(this.lastDelta) >= FlingManager.getPixelThreshold();
        }

        private Predicate<Integer> shouldStop(JScrollBar bar) {
            return TouchScroll.shouldStop(bar).or(v -> this.beginTime != 0L && System.currentTimeMillis() - this.beginTime > (long)FlingManager.getFlingInterruptLag());
        }

        public void start(JScrollBar bar, MouseWheelSmoothScroll.InertialAnimator animator) {
            if (bar != null && this.shouldStart()) {
                int initValue = bar.getValue();
                int targetValue = initValue + this.lastDelta * FlingManager.getFlingMultiplier();
                animator.start(initValue, targetValue, bar::setValue, this.shouldStop(bar), TouchAnimationSettings.SETTINGS);
            }
        }
    }
}

