/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomTarget
extends DelegatePsiTarget
implements PsiDeclaredTarget,
PomRenameableTarget {
    private final DomElement myDomElement;
    private final TextRange myRange;
    private final GenericDomValue myNameDomElement;

    private DomTarget(DomElement domElement, PsiElement navigationElement, TextRange range, GenericDomValue nameElement) {
        super(navigationElement);
        this.myDomElement = domElement;
        this.myRange = range;
        this.myNameDomElement = nameElement;
    }

    @Nullable
    public static DomTarget getTarget(@NotNull DomElement element) {
        GenericDomValue<?> nameElement;
        if (element == null) {
            DomTarget.$$$reportNull$$$0(0);
        }
        if ((nameElement = element.getGenericInfo().getNameDomElement(element)) == null) {
            return null;
        }
        return DomTarget.getTarget(element, nameElement);
    }

    @Nullable
    public static DomTarget getTarget(DomElement element, GenericDomValue nameElement) {
        XmlTag tag;
        if (nameElement instanceof GenericAttributeValue) {
            GenericAttributeValue genericAttributeValue = (GenericAttributeValue)nameElement;
            XmlAttributeValue attributeValue = genericAttributeValue.getXmlAttributeValue();
            if (attributeValue == null) {
                return null;
            }
            int length = attributeValue.getTextLength();
            if (length >= 2) {
                return new DomTarget(element, (PsiElement)attributeValue, new TextRange(1, length - 1), nameElement);
            }
        }
        if ((tag = nameElement.getXmlTag()) == null) {
            return null;
        }
        XmlTagValue tagValue = tag.getValue();
        if (StringUtil.isEmpty((String)tagValue.getTrimmedText())) {
            return null;
        }
        return new DomTarget(element, (PsiElement)tag, XmlTagUtil.getTrimmedValueRange((XmlTag)tag), nameElement);
    }

    public TextRange getNameIdentifierRange() {
        return this.myRange;
    }

    public boolean isWritable() {
        return this.getNavigationElement().isWritable();
    }

    public Object setName(@NotNull String newName) {
        if (newName == null) {
            DomTarget.$$$reportNull$$$0(1);
        }
        this.myNameDomElement.setStringValue(newName);
        return this.myDomElement;
    }

    @Nullable
    public String getName() {
        return this.myNameDomElement.getStringValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DomTarget domTarget = (DomTarget)((Object)o);
        return !(this.myDomElement != null ? !this.myDomElement.equals(domTarget.myDomElement) : domTarget.myDomElement != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myDomElement != null ? this.myDomElement.hashCode() : 0);
        result = 31 * result + (this.myRange != null ? this.myRange.hashCode() : 0);
        return result;
    }

    public DomElement getDomElement() {
        return this.myDomElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/DomTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

