/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.idea.IdeaLogger;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.project.TestProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.FixtureRuleKt;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TempFiles;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeavyPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static boolean ourReportedLeakedProjects;
    protected Project myProject;
    protected Module myModule;
    protected final Collection<Path> myFilesToDelete = new HashSet<Path>();
    private final TempFiles myTempFiles = new TempFiles(this.myFilesToDelete);
    protected boolean myAssertionsInTestDetected;
    private static TestCase ourTestCase;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    @Nullable
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private AccessToken projectTracker;
    private static final String[] PREFIX_CANDIDATES;

    @NotNull
    public TempFiles getTempDir() {
        TempFiles tempFiles = this.myTempFiles;
        if (tempFiles == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(0);
        }
        return tempFiles;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure() {
        VirtualFile virtualFile = PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, this.myFilesToDelete);
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(String rootPath) {
        VirtualFile virtualFile = PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, rootPath, this.myFilesToDelete);
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        if (tempDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(3);
        }
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    public static VirtualFile synchronizeTempDirVfs(@NotNull Path tempDir) {
        VirtualFile virtualFile;
        if (tempDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(4);
        }
        if ((virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)tempDir.toString()))) != null) {
            HeavyPlatformTestCase.synchronizeTempDirVfs(virtualFile);
        }
        return virtualFile;
    }

    protected void initApplication() throws Exception {
        TestApplicationManager testAppManager = TestApplicationManager.getInstance();
        testAppManager.setDataProvider(this);
        this.myOldSdks = new SdkLeakTracker();
    }

    public static void doAutodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            String markerPath = candidate == null ? "idea/ApplicationInfo.xml" : "META-INF/" + candidate + "Plugin.xml";
            URL resource = HeavyPlatformTestCase.class.getClassLoader().getResource(markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            HeavyPlatformTestCase.setPlatformPrefix(candidate);
            break;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFilesToDelete.add(Paths.get(FileUtilRt.getTempDirectory(), new String[0]));
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            HeavyPlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        this.projectTracker = ((TestProjectManager)ProjectManager.getInstance()).startTracking();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.setUpProject();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        boolean isTrackCodeStyleChanges = !this.isStressTest() && ApplicationManager.getApplication() != null && !(ApplicationManager.getApplication() instanceof MockApplication);
        this.myCodeStyleSettingsTracker = isTrackCodeStyleChanges ? new CodeStyleSettingsTracker(() -> CodeStyle.getDefaultSettings()) : null;
        ourTestCase = this;
        if (this.myProject != null) {
            CodeStyle.setTemporarySettings((Project)this.myProject, (CodeStyleSettings)CodeStyle.createTestSettings());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).clearUncommittedDocuments();
        }
        UIUtil.dispatchAllInvocationEvents();
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(5);
        }
        return psiManager;
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProject = this.doCreateProject(this.getProjectDirOrFile());
        LocalFileSystem.getInstance().refreshNioFiles(this.myFilesToDelete);
        PlatformTestUtil.openProject(this.myProject);
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            this.setUpModule();
            this.setUpJdk();
        }));
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    @NotNull
    protected Project doCreateProject(@NotNull Path projectFile) throws Exception {
        if (projectFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(6);
        }
        return HeavyPlatformTestCase.createProject(projectFile, this.getProjectFilename());
    }

    @NotNull
    public static Project createProject(@NotNull Path file2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(7);
        }
        return HeavyPlatformTestCase.createProject(file2, null);
    }

    @NotNull
    private static Project createProject(@NotNull Path file2, @Nullable String projectName) {
        Project project2;
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(8);
        }
        try {
            project2 = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().newProject(file2, FixtureRuleKt.createTestOpenProjectOptions().withProjectName(projectName)));
        }
        catch (TooManyProjectLeakedException e) {
            if (ourReportedLeakedProjects) {
                HeavyPlatformTestCase.fail((String)"Too many projects leaked, again.");
                if (null == null) {
                    HeavyPlatformTestCase.$$$reportNull$$$0(10);
                }
                return null;
            }
            ourReportedLeakedProjects = true;
            HeavyPlatformTestCase.reportLeakedProjects(e);
            if (null == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(11);
            }
            return null;
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(9);
        }
        return project2;
    }

    @NotNull
    public static String publishHeapDump(@NotNull String fileNamePrefix) {
        if (fileNamePrefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(12);
        }
        String fileName = fileNamePrefix + ".hprof.zip";
        File dumpFile = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), fileName);
        try {
            FileUtil.delete((File)dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped((File)dumpFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String dumpPath = dumpFile.getAbsolutePath();
        System.out.println("##teamcity[publishArtifacts '" + dumpPath + "']");
        String string = dumpPath;
        if (string == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Contract(value="_ -> fail")
    public static void reportLeakedProjects(@NotNull TooManyProjectLeakedException e) {
        if (e == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(14);
        }
        IntOpenHashSet hashCodes = new IntOpenHashSet();
        for (Project project2 : e.getLeakedProjects()) {
            hashCodes.add(System.identityHashCode(project2));
        }
        String dumpPath = HeavyPlatformTestCase.publishHeapDump("leakedProjects");
        StringBuilder leakers = new StringBuilder();
        leakers.append("Too many projects leaked: \n");
        LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, arg_0 -> HeavyPlatformTestCase.lambda$reportLeakedProjects$3((IntSet)hashCodes, arg_0), (arg_0, arg_1) -> HeavyPlatformTestCase.lambda$reportLeakedProjects$4(leakers, (IntSet)hashCodes, arg_0, arg_1));
        HeavyPlatformTestCase.fail((String)(leakers + "\nPlease see '" + dumpPath + "' for a memory dump"));
    }

    @NotNull
    protected Path getProjectDirOrFile() {
        return this.getProjectDirOrFile(false);
    }

    protected boolean isCreateProjectFileExplicitly() {
        return true;
    }

    @NotNull
    protected final Path getProjectDirOrFile(boolean isDirectoryBasedProject) {
        if (!isDirectoryBasedProject && this.isCreateProjectFileExplicitly()) {
            Path path;
            try {
                Path tempFile = FileUtil.createTempFile((String)this.getName(), (String)".ipr").toPath();
                this.myFilesToDelete.add(tempFile);
                path = tempFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (path == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(15);
            }
            return path;
        }
        Path tempFile = TemporaryDirectory.generateTemporaryPath(this.getProjectFilename() + (isDirectoryBasedProject ? "" : ".ipr"));
        this.myFilesToDelete.add(tempFile);
        Path path = tempFile;
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(16);
        }
        return path;
    }

    @Nullable
    private String getProjectFilename() {
        String testName = this.getName();
        return testName == null ? null : FileUtil.sanitizeFileName((String)testName, (boolean)false);
    }

    protected void setUpModule() {
        try {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                this.myModule = this.createMainModule();
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        Module module2 = this.createModule(this.myProject.getName());
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(17);
        }
        return module2;
    }

    @NotNull
    protected Module createModule(@NonNls @NotNull String moduleName) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(18);
        }
        Module module2 = this.doCreateRealModule(moduleName);
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(19);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModule(@NotNull String moduleName) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(20);
        }
        Module module2 = this.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(21);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModuleIn(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(22);
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(23);
        }
        if (moduleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(24);
        }
        Module module2 = this.createModuleAt(moduleName, project2, moduleType, Objects.requireNonNull(project2.getBasePath()));
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(25);
        }
        return module2;
    }

    @NotNull
    protected Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType, @NotNull String path) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(26);
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(27);
        }
        if (moduleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(28);
        }
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(29);
        }
        Module module2 = HeavyTestHelper.createModuleAt(moduleName, project2, moduleType, path, this.isCreateProjectFileExplicitly(), this.myFilesToDelete);
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(30);
        }
        return module2;
    }

    @NotNull
    protected ModuleType<?> getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(31);
        }
        return emptyModuleType;
    }

    public static void cleanupApplicationCaches(@Nullable Project project2) {
        LocalFileSystemImpl localFileSystem;
        FileBasedIndex fileBasedIndex;
        ProjectManagerEx projectManager;
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        if ((projectManager = ProjectManagerEx.getInstanceExIfCreated()) != null && projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)defaultProject)).cleanupForNextTest();
        }
        if ((fileBasedIndex = (FileBasedIndex)app.getServiceIfCreated(FileBasedIndex.class)) != null) {
            ((FileBasedIndexImpl)fileBasedIndex).cleanupForNextTest();
        }
        if (app.getServiceIfCreated(VirtualFileManager.class) != null && (localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance()) != null) {
            localFileSystem.cleanupForNextTest();
        }
    }

    @NotNull
    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            Set<VirtualFile> set = ourEternallyLivingFilesCache;
            if (set == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(32);
            }
            return set;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file2 : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                HeavyPlatformTestCase.registerSurvivor(survivors, file2);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        HashSet<VirtualFile> hashSet = survivors;
        if (hashSet == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    public static void addSurvivingFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(34);
        }
        for (VirtualFile virtualFile : files) {
            HeavyPlatformTestCase.registerSurvivor(HeavyPlatformTestCase.eternallyLivingFiles(), virtualFile);
        }
    }

    private static void registerSurvivor(@NotNull Set<? super VirtualFile> survivors, @NotNull VirtualFile file2) {
        if (survivors == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(36);
        }
        HeavyPlatformTestCase.addSubTree(file2, survivors);
        while (file2 != null && survivors.add((VirtualFile)file2)) {
            file2 = file2.getParent();
        }
    }

    private static void addSubTree(@NotNull VirtualFile root, @NotNull Set<? super VirtualFile> to) {
        if (root == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(37);
        }
        if (to == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(38);
        }
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add((VirtualFile)child);
                HeavyPlatformTestCase.addSubTree(child, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            TestApplicationManagerKt.waitForProjectLeakingThreads(project2);
        }
        RunAll.runAll(() -> this.disposeRootDisposable(), () -> {
            if (project2 != null) {
                TestApplicationManagerKt.tearDownProjectAndApp(project2);
            }
            this.myProject = null;
        }, () -> {
            AccessToken projectTracker = this.projectTracker;
            if (projectTracker != null) {
                this.projectTracker = null;
                projectTracker.finish();
            }
        }, () -> UIUtil.dispatchAllInvocationEvents(), () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            StartMarkAction.checkCleared((Project)project2);
            InplaceRefactoring.checkCleared();
        }, () -> {
            JarFileSystemImpl.cleanupForNextTest();
            this.getTempDir().deleteAll();
            LocalFileSystem.getInstance().refreshNioFiles(this.myFilesToDelete);
            LaterInvocator.dispatchPendingFlushes();
        }, () -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }, () -> super.tearDown(), () -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }, () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> this.myOldSdks.checkForJdkTableLeaks(), () -> this.myVirtualFilePointerTracker.assertPointersAreDisposed(), () -> {
            this.myModule = null;
            this.myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        });
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    @NotNull
    protected final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        if (disposable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(39);
        }
        Disposer.register((Disposable)this.myProject, disposable);
        T t = disposable;
        if (t == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(40);
        }
        return t;
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(41);
        }
        try {
            HeavyPlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == HeavyPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    protected void registerTestProjectJdk(Sdk jdk) {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk existingSdk : jdkTable.getAllJdks()) {
            if (existingSdk != jdk) continue;
            return;
        }
        WriteAction.runAndWait(() -> jdkTable.addJdk(jdk, (Disposable)this.myProject));
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        if (jdk != null) {
            this.registerTestProjectJdk(jdk);
        }
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.runBareImpl();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    HeavyPlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                }));
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl() throws Throwable {
        ThrowableRunnable runnable = () -> {
            try {
                this.myAssertionsInTestDetected = true;
                this.setUp();
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                try {
                    this.tearDown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            Throwable exception = null;
            try {
                this.myAssertionsInTestDetected = true;
                this.runTest();
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                exception = e;
            }
            finally {
                block17: {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable e) {
                        if (exception != null) break block17;
                        exception = e;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        HeavyPlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (runnable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(42);
        }
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(43);
        }
        Ref e = new Ref();
        Runnable runnable1 = () -> {
            try {
                if (ApplicationManager.getApplication().isDispatchThread() && this.isRunInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(runnable);
                } else {
                    runnable.run();
                }
            }
            catch (Exception e1) {
                e.set((Object)e1);
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (!e.isNull()) {
            throw (Exception)e.get();
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(44);
        }
        return this.myProject == null || this.myProject.isDisposed() ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix) throws IOException {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(45);
        }
        File file2 = this.createTempDir(prefix, true);
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(46);
        }
        return file2;
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix, boolean refresh) throws IOException {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(47);
        }
        File tempDirectory = FileUtilRt.createTempDirectory((String)("idea_test_" + prefix), null, (boolean)false);
        this.myFilesToDelete.add(tempDirectory.toPath());
        if (refresh) {
            HeavyPlatformTestCase.getVirtualFile(tempDirectory);
        }
        File file2 = tempDirectory;
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(48);
        }
        return file2;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(49);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    @NotNull
    protected File createTempDirectory() throws IOException {
        File file2 = this.createTempDir("");
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(50);
        }
        return file2;
    }

    @NotNull
    protected File createTempDirectory(boolean refresh) throws IOException {
        File file2 = this.createTempDir("", refresh);
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(51);
        }
        return file2;
    }

    @NotNull
    protected File createTempFile(@NotNull String name, @Nullable String text) throws IOException {
        File directory;
        File file2;
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(52);
        }
        if (!(file2 = new File(directory = this.createTempDirectory(), name)).createNewFile()) {
            throw new IOException("Can't create " + file2);
        }
        if (text != null) {
            FileUtil.writeToFile((File)file2, (String)text);
        }
        File file3 = file2;
        if (file3 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(53);
        }
        return file3;
    }

    public static void setContentOnDisk(@NotNull File file2, byte @Nullable [] bom, @NotNull String content, @NotNull Charset charset) throws IOException {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(54);
        }
        if (content == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(55);
        }
        if (charset == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(56);
        }
        FileOutputStream stream = new FileOutputStream(file2);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
    }

    @NotNull
    public VirtualFile createTempFile(@NonNls @NotNull String ext, byte @Nullable [] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        if (ext == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(57);
        }
        if (content == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(58);
        }
        if (charset == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(59);
        }
        File temp = FileUtil.createTempFile((String)"copy", (String)("." + ext));
        HeavyPlatformTestCase.setContentOnDisk(temp, bom, content, charset);
        this.myFilesToDelete.add(temp.toPath());
        VirtualFile file2 = HeavyPlatformTestCase.getVirtualFile(temp);
        assert (file2 != null) : temp;
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(60);
        }
        return virtualFile;
    }

    @Nullable
    protected PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(61);
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(62);
        }
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    @NotNull
    protected static VirtualFile createChildData(@NotNull VirtualFile dir, @NonNls @NotNull String name) {
        VirtualFile virtualFile;
        if (dir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(63);
        }
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(64);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildData(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(65);
        }
        return virtualFile;
    }

    @NotNull
    protected static VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NonNls @NotNull String name) {
        VirtualFile virtualFile;
        if (dir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(66);
        }
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(67);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildDirectory(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(68);
        }
        return virtualFile;
    }

    protected static void rename(@NotNull VirtualFile vFile1, @NotNull String newName) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(69);
        }
        if (newName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(70);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.rename((Object)vFile1, newName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void delete(@NotNull VirtualFile vFile1) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(71);
        }
        VfsTestUtil.deleteFile(vFile1);
    }

    public static void move(@NotNull VirtualFile vFile1, @NotNull VirtualFile newFile) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(72);
        }
        if (newFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(73);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.move((Object)vFile1, newFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile copy(@NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(74);
        }
        if (newParent == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(75);
        }
        if (copyName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(76);
        }
        VirtualFile[] copy = new VirtualFile[1];
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                copy[0] = file2.copy((Object)file2, newParent, copyName);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile virtualFile = copy[0];
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(77);
        }
        return virtualFile;
    }

    public static void copyDirContentsTo(@NotNull VirtualFile vTestRoot, @NotNull VirtualFile toDir) {
        if (vTestRoot == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(78);
        }
        if (toDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(79);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                for (VirtualFile file2 : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)file2, (VirtualFile)file2, (VirtualFile)toDir);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileText(@NotNull VirtualFile file2, @NotNull String text) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(80);
        }
        if (text == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(81);
        }
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(82);
        }
        if (content == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(83);
        }
        try {
            WriteAction.runAndWait(() -> file2.setBinaryContent(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object object) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(84);
        }
        if (content == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(85);
        }
        try {
            void requestor;
            WriteAction.runAndWait(() -> file2.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected VirtualFile getOrCreateProjectBaseDir() {
        String basePath = this.myProject.getBasePath();
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(basePath));
        if (baseDir == null) {
            try {
                Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            VirtualFile virtualFile = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath));
            if (virtualFile == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(86);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = baseDir;
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(87);
        }
        return virtualFile;
    }

    @NotNull
    protected final Path createTempDirectoryWithSuffix(@Nullable String suffix) throws IOException {
        Path path = FileUtilRt.createTempDirectory((String)this.getTestName(true), (String)suffix, (boolean)false).toPath();
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(88);
        }
        return path;
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module2) throws IOException {
        if (module2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(89);
        }
        File moduleDir = new File(PathUtil.getParentPath((String)module2.getModuleFilePath()));
        FileUtil.ensureExists((File)moduleDir);
        VirtualFile virtualFile = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir));
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(90);
        }
        return virtualFile;
    }

    private static /* synthetic */ boolean lambda$reportLeakedProjects$4(StringBuilder leakers, IntSet hashCodes, ProjectImpl leaked, Object backLink) {
        int hashCode = System.identityHashCode(leaked);
        leakers.append("Leaked project found:").append(leaked).append("; hash: ").append(hashCode).append("; place: ").append(TestProjectManager.getCreationPlace((Project)leaked)).append("\n");
        leakers.append(backLink).append("\n");
        leakers.append(";-----\n");
        hashCodes.remove(hashCode);
        return !hashCodes.isEmpty();
    }

    private static /* synthetic */ boolean lambda$reportLeakedProjects$3(IntSet hashCodes, ProjectImpl p) {
        return hashCodes.contains(System.identityHashCode(p));
    }

    static {
        PREFIX_CANDIDATES = new String[]{"Rider", "GoLand", "CLion", null, "AppCode", "SwiftTests", "CidrCommonTests", "DataGrip", "Python", "PyCharmCore", "Ruby", "PhpStorm", "UltimateLangXml", "Idea", "PlatformLangXml"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 89: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 89: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/HeavyPlatformTestCase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 7: 
            case 8: 
            case 36: 
            case 49: 
            case 54: 
            case 74: 
            case 80: 
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNamePrefix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "survivors";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 45: 
            case 47: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 52: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 55: 
            case 58: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 69: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile1";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vTestRoot";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProjectStructure";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/HeavyPlatformTestCase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "publishHeapDump";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirOrFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModule";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModuleIn";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleAt";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "eternallyLivingFiles";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "disposeOnTearDown";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 53: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectBaseDir";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectoryWithSuffix";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeTempDirVfs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "publishHeapDump";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportLeakedProjects";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModule";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModuleIn";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createModuleAt";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addSurvivingFiles";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerSurvivor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addSubTree";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "disposeOnTearDown";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resetClassFields";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runBareRunnable";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createTempDir";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 52: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setContentOnDisk";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setPlatformPrefix";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContentsTo";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "setFileText";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 89: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

