/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.connect.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.filters.LogEventBucketsFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFalseFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventSnapshotBuildFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistConditions;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EventLogUploadSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final String SEND = "send";
    private static final String METADATA = "metadata";
    private static final String DICTIONARY = "dictionary";
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;

    public EventLogUploadSettingsService(@NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo) {
        if (recorderId == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(0);
        }
        if (appInfo == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(1);
        }
        super(EventLogUploadSettingsService.getConfigUrl(recorderId, appInfo.getProductCode(), appInfo.getTemplateUrl(), appInfo.isTest()), appInfo);
        this.myApplicationInfo = appInfo;
    }

    @NotNull
    private static String getConfigUrl(@NotNull String recorderId, @NotNull String productCode, @NotNull String templateUrl, boolean isTest) {
        if (recorderId == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(2);
        }
        if (productCode == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(3);
        }
        if (templateUrl == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(4);
        }
        String string = String.format(templateUrl, recorderId, productCode);
        if (string == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public String getServiceUrl() {
        return this.getEndpointValue(SEND);
    }

    @Override
    @Nullable
    public String getDictionaryServiceUrl() {
        return this.getEndpointValue(DICTIONARY);
    }

    @Override
    public boolean isSettingsReachable() {
        return this.getExternalSettings() != null;
    }

    @Override
    public boolean isSendEnabled() {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null && settings.isSendEnabled();
    }

    @Override
    @NotNull
    public LogEventFilter getBaseEventFilter() {
        return new LogEventWhitelistFilter(EventLogUploadSettingsService.notNull(this.getWhitelistedGroups(), StatisticsWhitelistConditions.empty()));
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter(@NotNull LogEventFilter base, @NotNull EventLogBuildType type) {
        EventLogSendConfiguration configuration;
        if (base == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(6);
        }
        if (type == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(7);
        }
        if ((configuration = this.getConfiguration(type)) == null) {
            DataCollectorDebugLogger logger = this.myApplicationInfo.getLogger();
            if (logger.isTraceEnabled()) {
                logger.trace("Cannot find send configuration for '" + type + "' -> clean up log file");
            }
            LogEventFalseFilter logEventFalseFilter = LogEventFalseFilter.INSTANCE;
            if (logEventFalseFilter == null) {
                EventLogUploadSettingsService.$$$reportNull$$$0(8);
            }
            return logEventFalseFilter;
        }
        return new LogEventCompositeFilter(new LogEventBucketsFilter(configuration.getBuckets()), base, LogEventSnapshotBuildFilter.INSTANCE);
    }

    private static StatisticsWhitelistConditions notNull(@Nullable StatisticsWhitelistConditions whitelist, @NotNull StatisticsWhitelistConditions defaultValue) {
        if (defaultValue == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(9);
        }
        return whitelist != null ? whitelist : defaultValue;
    }

    @Override
    @NotNull
    public EventLogApplicationInfo getApplicationInfo() {
        EventLogApplicationInfo eventLogApplicationInfo = this.myApplicationInfo;
        if (eventLogApplicationInfo == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(10);
        }
        return eventLogApplicationInfo;
    }

    @Nullable
    protected StatisticsWhitelistConditions getWhitelistedGroups() {
        String productUrl = this.getWhiteListProductUrl();
        if (productUrl == null) {
            return null;
        }
        String userAgent = this.myApplicationInfo.getUserAgent();
        return StatisticsWhitelistLoader.getApprovedGroups(productUrl, userAgent);
    }

    @NonNls
    @Nullable
    public String getWhiteListProductUrl() {
        String baseWhitelistUrl = this.getEndpointValue(METADATA);
        if (baseWhitelistUrl == null) {
            return null;
        }
        return baseWhitelistUrl + this.myApplicationInfo.getProductCode() + ".json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productCode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateUrl";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogUploadSettingsService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogUploadSettingsService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigUrl";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEventFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

