/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class BindableDescriptorUtils {
    private BindableDescriptorUtils() {
    }

    public static String getDescriptorClassName(String className) {
        String packageName = BindableDescriptorUtils.getPackageName(className);
        String shortClassName = packageName.isEmpty() ? className : className.substring(packageName.length() + 1);
        int dollarIndex = shortClassName.lastIndexOf("$");
        if (dollarIndex >= 0) {
            shortClassName = shortClassName.substring(dollarIndex + 1);
        }
        return packageName + (packageName.isEmpty() ? "" : ".") + shortClassName + "Descriptor";
    }

    public static Class<? extends IBindableDescriptor> getDescriptorClass(Class<?> clazz) {
        if (clazz.getAnnotation(Bindable.class) == null) {
            throw new IllegalArgumentException("Class not marked with @Bindable: " + clazz.getName());
        }
        ClassLoader cl = clazz.getClassLoader();
        String descriptorClassName = BindableDescriptorUtils.getDescriptorClassName(clazz.getName());
        try {
            return Class.forName(descriptorClassName, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError("Descriptor class not found: " + descriptorClassName);
        }
    }

    public static IBindableDescriptor getDescriptor(Class<?> clazz) {
        try {
            return BindableDescriptorUtils.getDescriptorClass(clazz).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPackageName(String classFullName) {
        int lastDot = classFullName.lastIndexOf(46);
        return lastDot < 0 ? "" : classFullName.substring(0, lastDot);
    }
}

