/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Image;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class ChartConverter
extends ElementConverter {
    private static final ChartConverter INSTANCE = new ChartConverter();

    private ChartConverter() {
    }

    public static ChartConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRChart chart = (JRChart)element;
        this.copyElement(reportConverter, chart, printImage);
        printImage.copyBox(chart.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(chart.getAnchorNameExpression()));
        printImage.setBookmarkLevel(chart.getBookmarkLevel());
        printImage.setLinkType(chart.getLinkType());
        printImage.setOnErrorType((byte)3);
        printImage.setRenderer(this.getRenderer(chart));
        printImage.setScaleImage((byte)1);
        return printImage;
    }

    private JRRenderable getRenderer(JRChart chart) {
        JRRenderable imageRenderer = null;
        Image awtImage = null;
        try {
            awtImage = JRImageLoader.getImage((byte)3);
            imageRenderer = JRImageRenderer.getInstance(awtImage, (byte)1);
            chart.setStretchType((byte)0);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        return imageRenderer;
    }
}

