/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.pdu;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.ByteBufUtil;
import com.cloudhopper.smpp.util.PduUtil;
import io.netty.buffer.ByteBuf;

public class QuerySmResp
extends PduResponse {
    private String messageId;
    private String finalDate;
    private byte messageState;
    private byte errorCode;

    public QuerySmResp() {
        super(-2147483645, "query_sm_resp");
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String iMessageId) {
        this.messageId = iMessageId;
    }

    public String getFinalDate() {
        return this.finalDate;
    }

    public void setFinalDate(String iFinalDate) {
        this.finalDate = iFinalDate;
    }

    public byte getMessageState() {
        return this.messageState;
    }

    public void setMessageState(byte iMessageState) {
        this.messageState = iMessageState;
    }

    public byte getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(byte iErrorCode) {
        this.errorCode = iErrorCode;
    }

    @Override
    public void readBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.messageId = ByteBufUtil.readNullTerminatedString(buffer);
        this.finalDate = ByteBufUtil.readNullTerminatedString(buffer);
        this.messageState = buffer.readByte();
        this.errorCode = buffer.readByte();
    }

    @Override
    public int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.messageId);
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.finalDate);
        return bodyLength += 2;
    }

    @Override
    public void writeBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        ByteBufUtil.writeNullTerminatedString(buffer, this.messageId);
        ByteBufUtil.writeNullTerminatedString(buffer, this.finalDate);
        buffer.writeByte((int)this.messageState);
        buffer.writeByte((int)this.errorCode);
    }

    @Override
    public void appendBodyToString(StringBuilder buffer) {
        buffer.append("(messageId [");
        buffer.append(StringUtil.toStringWithNullAsEmpty((Object)this.messageId));
        buffer.append("] finalDate [");
        buffer.append(StringUtil.toStringWithNullAsEmpty((Object)this.finalDate));
        buffer.append("] messageState [0x");
        buffer.append(HexUtil.toHexString((byte)this.messageState));
        buffer.append("] errorCode [0x");
        buffer.append(HexUtil.toHexString((byte)this.errorCode));
        buffer.append("])");
    }
}

