/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import jde.debugger.CommandStream;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.SessionManager;
import jde.debugger.command.CommandHandler;

public class JDEbug
extends Thread
implements Protocol {
    public static final Integer debuggerID = new Integer(-1);
    public static JDEbug theDebugger = new JDEbug();
    private boolean m_shutdown = false;
    private CommandStream m_commandStream;

    protected JDEbug() {
    }

    public void init() throws IOException {
        this.m_commandStream = new CommandStream(new BufferedReader(new InputStreamReader(System.in)));
    }

    public void run() {
        JDE.debug(16, "Starting JDEbug main loop");
        while (!this.m_shutdown) {
            JDE.debug(16, "JDEbug waiting for cmd");
            List command = this.m_commandStream.nextCommand();
            JDE.debug(16, "JDEbug got cmd");
            Integer procID = Integer.valueOf(command.get(0).toString());
            Integer cmdID = Integer.valueOf(command.get(1).toString());
            String cmdName = command.get(2).toString().toLowerCase();
            List arguments = command.subList(3, command.size());
            try {
                CommandHandler handler = SessionManager.getCommandHandler(procID);
                if (handler == null) {
                    throw new JDEException("no command handler found for debugger process: " + procID);
                }
                JDE.debug(4, "JDEbug firing command event");
                handler.fireCommandEvent(procID, cmdID, cmdName, arguments);
            }
            catch (JDEException ex) {
                JDE.commandResult(cmdID, "Error occurred while executing " + cmdName + ". Error: " + ex, false, true);
            }
        }
        JDE.debug(16, "jdebug main loop terminating");
        SessionManager.shutdown();
    }

    public void shutdown() {
        this.m_shutdown = true;
    }
}

