/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.htmlparser.jericho.Config;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.SpiderTask;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderGitParser;
import org.zaproxy.zap.spider.parser.SpiderHtmlFormParser;
import org.zaproxy.zap.spider.parser.SpiderHtmlParser;
import org.zaproxy.zap.spider.parser.SpiderODataAtomParser;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.spider.parser.SpiderParserListener;
import org.zaproxy.zap.spider.parser.SpiderRedirectParser;
import org.zaproxy.zap.spider.parser.SpiderRobotstxtParser;
import org.zaproxy.zap.spider.parser.SpiderSVNEntriesParser;
import org.zaproxy.zap.spider.parser.SpiderSitemapXMLParser;
import org.zaproxy.zap.spider.parser.SpiderTextParser;

public class SpiderController
implements SpiderParserListener {
    private LinkedList<FetchFilter> fetchFilters;
    private LinkedList<ParseFilter> parseFilters;
    private LinkedList<SpiderParser> parsers;
    private List<SpiderParser> parsersUnmodifiableView;
    private Spider spider;
    private Set<String> visitedGet;
    private Map<String, ArrayList<String>> visitedPost;
    private static final Logger log = Logger.getLogger(SpiderController.class);

    protected SpiderController(Spider spider, List<SpiderParser> customParsers) {
        this.spider = spider;
        this.fetchFilters = new LinkedList();
        this.parseFilters = new LinkedList();
        this.visitedGet = new HashSet<String>();
        this.visitedPost = new HashMap<String, ArrayList<String>>();
        this.prepareDefaultParsers();
        for (SpiderParser parser : customParsers) {
            this.addSpiderParser(parser);
        }
    }

    private void prepareDefaultParsers() {
        SpiderParser parser;
        this.parsers = new LinkedList();
        if (this.spider.getSpiderParam().isParseRobotsTxt()) {
            parser = new SpiderRobotstxtParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        }
        if (this.spider.getSpiderParam().isParseSitemapXml()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding SpiderSitemapXMLParser");
            }
            parser = new SpiderSitemapXMLParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"NOT Adding SpiderSitemapXMLParser");
        }
        if (this.spider.getSpiderParam().isParseSVNEntries()) {
            parser = new SpiderSVNEntriesParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        }
        if (this.spider.getSpiderParam().isParseGit()) {
            parser = new SpiderGitParser(this.spider.getSpiderParam());
            this.parsers.add(parser);
        }
        parser = new SpiderRedirectParser();
        this.parsers.add(parser);
        parser = new SpiderHtmlParser(this.spider.getSpiderParam());
        this.parsers.add(parser);
        parser = new SpiderHtmlFormParser(this.spider.getSpiderParam(), this.spider.getExtensionSpider().getValueGenerator());
        this.parsers.add(parser);
        Config.CurrentCompatibilityMode.setFormFieldNameCaseInsensitive(false);
        parser = new SpiderODataAtomParser();
        this.parsers.add(parser);
        parser = new SpiderTextParser();
        this.parsers.add(parser);
        this.parsersUnmodifiableView = Collections.unmodifiableList(this.parsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSeed(URI uri, String method) {
        String visitedURI;
        try {
            visitedURI = URLCanonicalizer.buildCleanedParametersURIRepresentation(uri, this.spider.getSpiderParam().getHandleParameters(), this.spider.getSpiderParam().isHandleODataParametersVisited());
        }
        catch (URIException e) {
            return;
        }
        Set<String> e = this.visitedGet;
        synchronized (e) {
            if (this.visitedGet.contains(visitedURI)) {
                log.debug((Object)("URI already visited: " + visitedURI));
                return;
            }
            this.visitedGet.add(visitedURI);
        }
        SpiderTask task = new SpiderTask(this.spider, null, uri, 0, method);
        this.spider.submitTask(task);
        this.spider.notifyListenersFoundURI(uri.toString(), method, FetchFilter.FetchStatus.SEED);
    }

    protected LinkedList<FetchFilter> getFetchFilters() {
        return this.fetchFilters;
    }

    public void addFetchFilter(FetchFilter filter) {
        log.debug((Object)("Loading fetch filter: " + filter.getClass().getSimpleName()));
        this.fetchFilters.add(filter);
    }

    protected LinkedList<ParseFilter> getParseFilters() {
        return this.parseFilters;
    }

    public void addParseFilter(ParseFilter filter) {
        log.debug((Object)("Loading parse filter: " + filter.getClass().getSimpleName()));
        this.parseFilters.add(filter);
    }

    public void init() {
        this.visitedGet.clear();
        this.visitedPost.clear();
        for (SpiderParser parser : this.parsers) {
            parser.addSpiderParserListener(this);
        }
    }

    public void reset() {
        this.visitedGet.clear();
        this.visitedPost.clear();
        for (SpiderParser parser : this.parsers) {
            parser.removeSpiderParserListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceURIFound(HttpMessage responseMessage, int depth, String uri, boolean shouldIgnore) {
        String visitedURI;
        log.debug((Object)("New resource found: " + uri));
        if (uri == null) {
            return;
        }
        URI uriV = this.createURI(uri);
        if (uriV == null) {
            return;
        }
        try {
            visitedURI = URLCanonicalizer.buildCleanedParametersURIRepresentation(uriV, this.spider.getSpiderParam().getHandleParameters(), this.spider.getSpiderParam().isHandleODataParametersVisited());
        }
        catch (URIException e) {
            return;
        }
        Set<String> e = this.visitedGet;
        synchronized (e) {
            if (this.visitedGet.contains(visitedURI)) {
                return;
            }
            this.visitedGet.add(visitedURI);
        }
        for (FetchFilter f : this.fetchFilters) {
            FetchFilter.FetchStatus s = f.checkFilter(uriV);
            if (s == FetchFilter.FetchStatus.VALID) continue;
            log.debug((Object)("URI: " + uriV + " was filtered by a filter with reason: " + (Object)((Object)s)));
            this.spider.notifyListenersFoundURI(uri, "GET", s);
            return;
        }
        if (shouldIgnore) {
            log.debug((Object)("URI: " + uriV + " is valid, but will not be fetched, by parser recommendation."));
            this.spider.notifyListenersFoundURI(uri, "GET", FetchFilter.FetchStatus.VALID);
            return;
        }
        this.spider.notifyListenersFoundURI(uri, "GET", FetchFilter.FetchStatus.VALID);
        SpiderTask task = new SpiderTask(this.spider, responseMessage.getRequestHeader().getURI(), uriV, depth, "GET");
        this.spider.submitTask(task);
    }

    @Override
    public void resourceURIFound(HttpMessage responseMessage, int depth, String uri) {
        this.resourceURIFound(responseMessage, depth, uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourcePostURIFound(HttpMessage responseMessage, int depth, String uri, String requestBody) {
        log.debug((Object)("New POST resource found: " + uri));
        Map<String, ArrayList<String>> map = this.visitedPost;
        synchronized (map) {
            if (this.arrayKeyValueExists(uri, requestBody)) {
                log.debug((Object)("URI already visited: " + uri));
                return;
            }
            if (this.visitedPost.containsKey(uri)) {
                this.visitedPost.get(uri).add(requestBody);
            } else {
                ArrayList<String> l = new ArrayList<String>();
                l.add(requestBody);
                this.visitedPost.put(uri, l);
            }
        }
        URI uriV = this.createURI(uri);
        if (uriV == null) {
            return;
        }
        for (FetchFilter f : this.fetchFilters) {
            FetchFilter.FetchStatus s = f.checkFilter(uriV);
            if (s == FetchFilter.FetchStatus.VALID) continue;
            log.debug((Object)("URI: " + uriV + " was filtered by a filter with reason: " + (Object)((Object)s)));
            this.spider.notifyListenersFoundURI(uri, "POST", s);
            return;
        }
        this.spider.notifyListenersFoundURI(uri, "POST", FetchFilter.FetchStatus.VALID);
        SpiderTask task = new SpiderTask(this.spider, responseMessage.getRequestHeader().getURI(), uriV, depth, "POST", requestBody);
        this.spider.submitTask(task);
    }

    private boolean arrayKeyValueExists(String key, String value) {
        if (this.visitedPost.containsKey(key)) {
            for (String s : this.visitedPost.get(key)) {
                if (!s.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private URI createURI(String uri) {
        URI uriV = null;
        try {
            uriV = new URI(uri, true);
        }
        catch (URIException e) {
            try {
                log.debug((Object)"Second try...");
                uriV = new URI(uri, false);
            }
            catch (Exception ex) {
                log.error((Object)("Error while converting to uri: " + uri), (Throwable)ex);
                return null;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while converting to uri: " + uri), (Throwable)e);
            return null;
        }
        return uriV;
    }

    public List<SpiderParser> getParsers() {
        return this.parsersUnmodifiableView;
    }

    public void addSpiderParser(SpiderParser parser) {
        log.debug((Object)("Loading custom Spider Parser: " + parser.getClass().getSimpleName()));
        this.parsers.addFirst(parser);
    }
}

