/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginHandler;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;

public class DefaultAutoAppliedPluginHandler
implements AutoAppliedPluginHandler {
    private final AutoAppliedPluginRegistry registry;

    public DefaultAutoAppliedPluginHandler(AutoAppliedPluginRegistry registry) {
        this.registry = registry;
    }

    public PluginRequests mergeWithAutoAppliedPlugins(PluginRequests initialRequests, Object pluginTarget) {
        if (pluginTarget instanceof Project) {
            Project project = (Project)pluginTarget;
            PluginRequests autoAppliedPlugins = this.registry.getAutoAppliedPlugins(project);
            if (autoAppliedPlugins.isEmpty()) {
                return initialRequests;
            }
            return this.mergePluginRequests(autoAppliedPlugins, initialRequests, project.getPlugins(), project.getBuildscript());
        }
        if (pluginTarget instanceof Settings) {
            Settings settings = (Settings)pluginTarget;
            PluginRequests autoAppliedPlugins = this.registry.getAutoAppliedPlugins(settings);
            if (autoAppliedPlugins.isEmpty()) {
                return initialRequests;
            }
            return this.mergePluginRequests(autoAppliedPlugins, initialRequests, settings.getPlugins(), settings.getBuildscript());
        }
        return initialRequests;
    }

    PluginRequests mergePluginRequests(PluginRequests autoAppliedPlugins, PluginRequests initialRequests, PluginContainer pluginContainer, ScriptHandler scriptHandler) {
        PluginRequests filteredAutoAppliedPlugins = this.filterAlreadyAppliedOrRequested(autoAppliedPlugins, initialRequests, pluginContainer, scriptHandler);
        return filteredAutoAppliedPlugins.mergeWith(initialRequests);
    }

    private PluginRequests filterAlreadyAppliedOrRequested(PluginRequests autoAppliedPlugins, PluginRequests initialRequests, PluginContainer pluginContainer, ScriptHandler scriptHandler) {
        return PluginRequests.of((List)ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)autoAppliedPlugins, autoAppliedPlugin -> !DefaultAutoAppliedPluginHandler.isAlreadyAppliedOrRequested(autoAppliedPlugin, initialRequests, pluginContainer, scriptHandler))));
    }

    private static boolean isAlreadyAppliedOrRequested(PluginRequestInternal autoAppliedPlugin, PluginRequests requests, PluginContainer pluginContainer, ScriptHandler scriptHandler) {
        return DefaultAutoAppliedPluginHandler.isAlreadyApplied(autoAppliedPlugin, pluginContainer) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInPluginsBlock(autoAppliedPlugin, requests) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInBuildScriptBlock(autoAppliedPlugin, scriptHandler);
    }

    private static boolean isAlreadyApplied(PluginRequestInternal autoAppliedPlugin, PluginContainer pluginContainer) {
        return pluginContainer.hasPlugin(autoAppliedPlugin.getId().getId());
    }

    private static boolean isAlreadyRequestedInPluginsBlock(PluginRequestInternal autoAppliedPlugin, PluginRequests requests) {
        for (PluginRequestInternal request : requests) {
            if (!autoAppliedPlugin.getId().equals(request.getId())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlreadyRequestedInBuildScriptBlock(PluginRequestInternal autoAppliedPlugin, ScriptHandler scriptHandler) {
        ModuleVersionSelector module = autoAppliedPlugin.getModule();
        if (module == null) {
            return false;
        }
        Configuration classpathConfiguration = scriptHandler.getConfigurations().getByName("classpath");
        for (Dependency dependency : classpathConfiguration.getDependencies()) {
            if (!module.getGroup().equals(dependency.getGroup()) || !module.getName().equals(dependency.getName())) continue;
            return true;
        }
        return false;
    }
}

