/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.launcher.daemon.server.health.DaemonHealthStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;

public class DaemonMemoryStatus {
    private static final Logger LOGGER = Logging.getLogger(DaemonMemoryStatus.class);
    public static final String ENABLE_PERFORMANCE_MONITORING = "org.gradle.daemon.performance.enable-monitoring";
    private static final String HEAP = "heap";
    private static final String NON_HEAP = "non-heap";
    private final DaemonHealthStats stats;
    private final int heapUsageThreshold;
    private final double heapRateThreshold;
    private final int nonHeapUsageThreshold;
    private final double thrashingThreshold;

    public DaemonMemoryStatus(DaemonHealthStats stats, int heapUsageThreshold, double heapRateThreshold, int nonHeapUsageThreshold, double thrashingThreshold) {
        this.stats = stats;
        this.heapUsageThreshold = heapUsageThreshold;
        this.heapRateThreshold = heapRateThreshold;
        this.nonHeapUsageThreshold = nonHeapUsageThreshold;
        this.thrashingThreshold = thrashingThreshold;
    }

    public boolean isHeapSpaceExhausted() {
        GarbageCollectionStats gcStats = this.stats.getHeapStats();
        return this.exceedsThreshold(HEAP, gcStats, new Spec<GarbageCollectionStats>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectionStats gcStats) {
                return DaemonMemoryStatus.this.heapUsageThreshold != 0 && DaemonMemoryStatus.this.heapRateThreshold != 0.0 && gcStats.isValid() && gcStats.getUsedPercent() >= DaemonMemoryStatus.this.heapUsageThreshold && gcStats.getGcRate() >= DaemonMemoryStatus.this.heapRateThreshold;
            }
        });
    }

    public boolean isNonHeapSpaceExhausted() {
        GarbageCollectionStats gcStats = this.stats.getNonHeapStats();
        return this.exceedsThreshold(NON_HEAP, gcStats, new Spec<GarbageCollectionStats>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectionStats gcStats) {
                return DaemonMemoryStatus.this.nonHeapUsageThreshold != 0 && gcStats.isValid() && gcStats.getUsedPercent() >= DaemonMemoryStatus.this.nonHeapUsageThreshold;
            }
        });
    }

    public boolean isThrashing() {
        GarbageCollectionStats gcStats = this.stats.getHeapStats();
        return this.exceedsThreshold(HEAP, gcStats, new Spec<GarbageCollectionStats>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectionStats gcStats) {
                return DaemonMemoryStatus.this.heapUsageThreshold != 0 && DaemonMemoryStatus.this.thrashingThreshold != 0.0 && gcStats.isValid() && gcStats.getUsedPercent() >= DaemonMemoryStatus.this.heapUsageThreshold && gcStats.getGcRate() >= DaemonMemoryStatus.this.thrashingThreshold;
            }
        });
    }

    private boolean exceedsThreshold(String pool, GarbageCollectionStats gcStats, Spec<GarbageCollectionStats> spec) {
        if (this.isEnabled() && spec.isSatisfiedBy(gcStats)) {
            if (gcStats.isValid() && gcStats.getUsedPercent() > 0) {
                LOGGER.debug(String.format("%s: GC rate: %.2f/s %s usage: %s%%", pool, gcStats.getGcRate(), pool, gcStats.getUsedPercent()));
            } else {
                LOGGER.debug("{}: GC rate: 0.0/s", (Object)pool);
            }
            return true;
        }
        return false;
    }

    private boolean isEnabled() {
        String enabledValue = System.getProperty(ENABLE_PERFORMANCE_MONITORING, "true");
        return Boolean.parseBoolean(enabledValue);
    }
}

