/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformCompletion;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformingAsyncArtifactListener;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public abstract class AbstractTransformedArtifactSet
implements ResolvedArtifactSet,
FileCollectionInternal.Source {
    private final ResolvedArtifactSet delegate;
    private final ImmutableAttributes targetVariantAttributes;
    private final Transformation transformation;
    private final TransformationNodeRegistry transformationNodeRegistry;
    private final ExecutionGraphDependenciesResolver dependenciesResolver;

    public AbstractTransformedArtifactSet(ComponentIdentifier componentIdentifier, ResolvedArtifactSet delegate, ImmutableAttributes targetVariantAttributes, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory, TransformationNodeRegistry transformationNodeRegistry) {
        this.delegate = delegate;
        this.targetVariantAttributes = targetVariantAttributes;
        this.transformation = transformation;
        this.transformationNodeRegistry = transformationNodeRegistry;
        this.dependenciesResolver = dependenciesResolverFactory.create(componentIdentifier);
    }

    public ImmutableAttributes getTargetVariantAttributes() {
        return this.targetVariantAttributes;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public ExecutionGraphDependenciesResolver getDependenciesResolver() {
        return this.dependenciesResolver;
    }

    @Override
    public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
        FileCollectionStructureVisitor.VisitType visitType = listener.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            return visitor -> visitor.endVisitCollection(this);
        }
        ConcurrentMap artifactResults = Maps.newConcurrentMap();
        ResolvedArtifactSet.Completion result = this.delegate.startVisit(actions, new TransformingAsyncArtifactListener(this.transformation, actions, artifactResults, this.dependenciesResolver, this.transformationNodeRegistry));
        return new TransformCompletion(result, (AttributeContainerInternal)this.targetVariantAttributes, artifactResults);
    }

    @Override
    public void visitLocalArtifacts(ResolvedArtifactSet.LocalArtifactVisitor visitor) {
        throw new IllegalStateException();
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        throw new IllegalStateException();
    }
}

