/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsRSAUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsRSAKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 1: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsRSAKeyExchange(int n) {
        super(TlsRSAKeyExchange.checkKeyExchange(n));
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireDecryptorCredentials(tlsCredentials);
    }

    @Override
    public void processServerCertificate(Certificate certificate) throws IOException {
        this.serverCertificate = certificate.getCertificateAt(0).useInRole(0, 1);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{1, 2, 64};
    }

    @Override
    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(tlsCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, outputStream);
    }

    @Override
    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), byArray);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tlsSecret = this.preMasterSecret;
        this.preMasterSecret = null;
        return tlsSecret;
    }
}

