/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractBitVector;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.NilVector;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class SimpleString
extends AbstractString {
    private int capacity;
    private char[] chars;

    public SimpleString(LispCharacter c) {
        this.chars = new char[1];
        this.chars[0] = c.value;
        this.capacity = 1;
    }

    public SimpleString(char c) {
        this.chars = new char[1];
        this.chars[0] = c;
        this.capacity = 1;
    }

    public SimpleString(int capacity) {
        this.capacity = capacity;
        this.chars = new char[capacity];
    }

    public SimpleString(String s) {
        this.capacity = s.length();
        this.chars = s.toCharArray();
    }

    public SimpleString(StringBuffer sb) {
        this.capacity = sb.length();
        this.chars = new char[this.capacity];
        sb.getChars(0, this.capacity, this.chars, 0);
    }

    public SimpleString(StringBuilder sb) {
        this.chars = sb.toString().toCharArray();
        this.capacity = this.chars.length;
    }

    public SimpleString(char[] chars) {
        this.chars = chars;
        this.capacity = chars.length;
    }

    @Override
    public char[] chars() {
        return this.chars;
    }

    @Override
    public char[] getStringChars() {
        return this.chars;
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_BASE_STRING, Fixnum.getInstance(this.capacity));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SIMPLE_BASE_STRING;
    }

    @Override
    public LispObject getDescription() {
        StringBuilder sb = new StringBuilder("A simple-string (");
        sb.append(this.capacity);
        sb.append(") \"");
        sb.append(this.chars);
        sb.append('\"');
        return new SimpleString(sb);
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_STRING) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_BASE_STRING) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_STRING) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_BASE_STRING) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject SIMPLE_STRING_P() {
        return Lisp.T;
    }

    @Override
    public boolean hasFillPointer() {
        return false;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleString) {
            SimpleString string = (SimpleString)obj;
            if (string.capacity != this.capacity) {
                return false;
            }
            int i = this.capacity;
            while (i-- > 0) {
                if (string.chars[i] == this.chars[i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof AbstractString) {
            AbstractString string = (AbstractString)obj;
            if (string.length() != this.capacity) {
                return false;
            }
            int i = this.length();
            while (i-- > 0) {
                if (string.charAt(i) == this.chars[i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof NilVector) {
            return obj.equal(this);
        }
        return false;
    }

    @Override
    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleString) {
            SimpleString string = (SimpleString)obj;
            if (string.capacity != this.capacity) {
                return false;
            }
            int i = this.capacity;
            while (i-- > 0) {
                if (string.chars[i] == this.chars[i] || LispCharacter.toLowerCase(string.chars[i]) == LispCharacter.toLowerCase(this.chars[i])) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof AbstractString) {
            AbstractString string = (AbstractString)obj;
            if (string.length() != this.capacity) {
                return false;
            }
            int i = this.length();
            while (i-- > 0) {
                if (string.charAt(i) == this.chars[i] || LispCharacter.toLowerCase(string.charAt(i)) == LispCharacter.toLowerCase(this.chars[i])) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof AbstractBitVector) {
            return false;
        }
        if (obj instanceof AbstractArray) {
            return obj.equalp(this);
        }
        return false;
    }

    public final SimpleString substring(int start) {
        return this.substring(start, this.capacity);
    }

    public final SimpleString substring(int start, int end) {
        SimpleString s = new SimpleString(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                s.chars[j++] = this.chars[i++];
            }
            return s;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Lisp.error(new TypeError("Array index out of bounds: " + i));
            return null;
        }
    }

    @Override
    public final LispObject subseq(int start, int end) {
        return this.substring(start, end);
    }

    @Override
    public void fill(LispObject obj) {
        this.fill(LispCharacter.getValue(obj));
    }

    @Override
    public void fill(char c) {
        int i = this.capacity;
        while (i-- > 0) {
            this.chars[i] = c;
        }
    }

    @Override
    public void shrink(int n) {
        if (n < this.capacity) {
            char[] newArray = new char[n];
            System.arraycopy(this.chars, 0, newArray, 0, n);
            this.chars = newArray;
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError());
    }

    @Override
    public LispObject reverse() {
        SimpleString result = new SimpleString(this.capacity);
        int i = 0;
        int j = this.capacity - 1;
        while (i < this.capacity) {
            result.chars[i] = this.chars[j];
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity - 1; i < j; ++i, --j) {
            char temp = this.chars[i];
            this.chars[i] = this.chars[j];
            this.chars[j] = temp;
        }
        return this;
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.chars);
    }

    @Override
    public Object javaInstance() {
        return String.valueOf(this.chars);
    }

    public Object javaInstance(Class c) {
        return this.javaInstance();
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int length() {
        return this.capacity;
    }

    @Override
    public char charAt(int index) {
        try {
            return this.chars[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return '\u0000';
        }
    }

    @Override
    public void setCharAt(int index, char c) {
        try {
            this.chars[index] = c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public LispObject elt(int index) {
        try {
            return LispCharacter.getInstance(this.chars[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public LispObject CHAR(int index) {
        try {
            return LispCharacter.getInstance(this.chars[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public LispObject SCHAR(int index) {
        try {
            return LispCharacter.getInstance(this.chars[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public LispObject AREF(int index) {
        try {
            return LispCharacter.getInstance(this.chars[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public void aset(int index, LispObject obj) {
        try {
            this.chars[index] = LispCharacter.getValue(obj);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public int sxhash() {
        if (this.capacity == 0) {
            return 0;
        }
        int hashCode = Lisp.randomStringHashBase;
        for (int i = 0; i < this.capacity; ++i) {
            hashCode += this.chars[i];
            hashCode += hashCode << 10;
            hashCode ^= hashCode >> 6;
        }
        hashCode += hashCode << 3;
        hashCode ^= hashCode >> 11;
        hashCode += hashCode << 15;
        return hashCode & Integer.MAX_VALUE;
    }

    @Override
    public int psxhash() {
        if (this.capacity == 0) {
            return 0;
        }
        int hashCode = Lisp.randomStringHashBase;
        for (int i = 0; i < this.capacity; ++i) {
            hashCode += Character.toUpperCase(this.chars[i]);
            hashCode += hashCode << 10;
            hashCode ^= hashCode >> 6;
        }
        hashCode += hashCode << 3;
        hashCode ^= hashCode >> 11;
        hashCode += hashCode << 15;
        return hashCode & Integer.MAX_VALUE;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            char[] newChars = new char[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newChars[i] = LispCharacter.getValue(list.car());
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newChars[i] = LispCharacter.getValue(initialContents.elt(i));
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return new SimpleString(newChars);
        }
        if (this.capacity != newCapacity) {
            char[] newChars = new char[newCapacity];
            System.arraycopy(this.chars, 0, newChars, 0, Math.min(newCapacity, this.capacity));
            if (initialElement != null && this.capacity < newCapacity) {
                char c = LispCharacter.getValue(initialElement);
                for (int i = this.capacity; i < newCapacity; ++i) {
                    newChars[i] = c;
                }
            }
            return new SimpleString(newChars);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexString(newCapacity, displacedTo, displacement);
    }

    @Override
    public String toString() {
        return String.valueOf(this.chars);
    }
}

