/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.suggest.Suggest;

public final class CompletionSuggestion
extends Suggest.Suggestion<Entry> {
    @Deprecated
    public static final int TYPE = 4;
    private boolean skipDuplicates;

    public CompletionSuggestion(String name, int size, boolean skipDuplicates) {
        super(name, size);
        this.skipDuplicates = skipDuplicates;
    }

    public CompletionSuggestion(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.skipDuplicates = in.readBoolean();
        }
    }

    @Override
    public String getWriteableName() {
        return "completion";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.skipDuplicates);
        }
    }

    public List<Entry.Option> getOptions() {
        if (!this.entries.isEmpty()) {
            assert (this.entries.size() == 1) : "CompletionSuggestion must have only one entry";
            return ((Entry)this.entries.get(0)).getOptions();
        }
        return Collections.emptyList();
    }

    public boolean hasScoreDocs() {
        return this.getOptions().size() > 0;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals(this.skipDuplicates, ((CompletionSuggestion)other).skipDuplicates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.skipDuplicates);
    }

    public static CompletionSuggestion fromXContent(XContentParser parser, String name) throws IOException {
        CompletionSuggestion suggestion = new CompletionSuggestion(name, -1, false);
        CompletionSuggestion.parseEntries(parser, suggestion, Entry::fromXContent);
        return suggestion;
    }

    public CompletionSuggestion reduce(List<Suggest.Suggestion<Entry>> toReduce) {
        if (toReduce.isEmpty()) {
            return null;
        }
        CompletionSuggestion leader = (CompletionSuggestion)toReduce.get(0);
        Entry leaderEntry = (Entry)leader.getEntries().get(0);
        String name = leader.getName();
        int size = leader.getSize();
        if (toReduce.size() == 1) {
            return leader;
        }
        OptionPriorityQueue pq = new OptionPriorityQueue(toReduce.size());
        for (Suggest.Suggestion<Entry> suggestion : toReduce) {
            assert (suggestion.getName().equals(name)) : "name should be identical across all suggestions";
            Iterator<Entry.Option> it = ((CompletionSuggestion)suggestion).getOptions().iterator();
            if (!it.hasNext()) continue;
            pq.add(new ShardOptions(it));
        }
        CharArraySet seenSurfaceForms = leader.skipDuplicates ? new CharArraySet(leader.getSize(), false) : null;
        Entry entry = new Entry(leaderEntry.getText(), leaderEntry.getOffset(), leaderEntry.getLength());
        List options = entry.getOptions();
        while (pq.size() > 0) {
            ShardOptions top = (ShardOptions)pq.top();
            Entry.Option current = top.current;
            if (top.advanceToNextOption()) {
                pq.updateTop();
            } else {
                pq.pop();
            }
            if (leader.skipDuplicates && !seenSurfaceForms.add(current.getText().toString())) continue;
            options.add(current);
            if (options.size() < size) continue;
            break;
        }
        CompletionSuggestion suggestion = new CompletionSuggestion(leader.getName(), leader.getSize(), leader.skipDuplicates);
        suggestion.addTerm(entry);
        return suggestion;
    }

    public void setShardIndex(int shardIndex) {
        if (!this.entries.isEmpty()) {
            for (Entry.Option option : this.getOptions()) {
                option.setShardIndex(shardIndex);
            }
        }
    }

    @Override
    public int getWriteableType() {
        return 4;
    }

    @Override
    protected Entry newEntry(StreamInput in) throws IOException {
        return new Entry(in);
    }

    public static final class Entry
    extends Suggest.Suggestion.Entry<Option> {
        private static final ObjectParser<Entry, Void> PARSER = new ObjectParser("CompletionSuggestionEntryParser", true, Entry::new);

        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        private Entry() {
        }

        public Entry(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        protected Option newOption(StreamInput in) throws IOException {
            return new Option(in);
        }

        public static Entry fromXContent(XContentParser parser) {
            return (Entry)PARSER.apply(parser, null);
        }

        static {
            Entry.declareCommonFields(PARSER);
            PARSER.declareObjectArray((e, o) -> e.addOptions(o), (p, c) -> Option.fromXContent(p), new ParseField("options", new String[0]));
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private final Map<String, Set<String>> contexts;
            private final ScoreDoc doc;
            private SearchHit hit;
            public static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
            private static final ObjectParser<Map<String, Object>, Void> PARSER = new ObjectParser("CompletionOptionParser", SearchHit.unknownMetaFieldConsumer, HashMap::new);

            public Option(int docID, Text text, float score, Map<String, Set<String>> contexts) {
                super(text, score);
                this.doc = new ScoreDoc(docID, score);
                this.contexts = Objects.requireNonNull(contexts, "context map cannot be null");
            }

            public Option(StreamInput in) throws IOException {
                super(in);
                this.doc = Lucene.readScoreDoc(in);
                if (in.readBoolean()) {
                    this.hit = new SearchHit(in);
                }
                int contextSize = in.readInt();
                this.contexts = new LinkedHashMap<String, Set<String>>(contextSize);
                for (int i = 0; i < contextSize; ++i) {
                    String contextName = in.readString();
                    int nContexts = in.readVInt();
                    HashSet<String> contexts = new HashSet<String>(nContexts);
                    for (int j = 0; j < nContexts; ++j) {
                        contexts.add(in.readString());
                    }
                    this.contexts.put(contextName, contexts);
                }
            }

            @Override
            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                throw new UnsupportedOperationException();
            }

            public Map<String, Set<String>> getContexts() {
                return this.contexts;
            }

            public ScoreDoc getDoc() {
                return this.doc;
            }

            public SearchHit getHit() {
                return this.hit;
            }

            public void setShardIndex(int shardIndex) {
                this.doc.shardIndex = shardIndex;
            }

            public void setHit(SearchHit hit) {
                this.hit = hit;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field(TEXT.getPreferredName(), (ToXContent)this.getText());
                if (this.hit != null) {
                    this.hit.toInnerXContent(builder, params);
                } else {
                    builder.field(SCORE.getPreferredName(), this.getScore());
                }
                if (this.contexts.size() > 0) {
                    builder.startObject(CONTEXTS.getPreferredName());
                    for (Map.Entry<String, Set<String>> entry : this.contexts.entrySet()) {
                        builder.startArray(entry.getKey());
                        for (CharSequence charSequence : entry.getValue()) {
                            builder.value(charSequence.toString());
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                return builder;
            }

            private static Map<String, Set<String>> parseContexts(XContentParser parser) throws IOException {
                HashMap<String, Set<String>> contexts = new HashMap<String, Set<String>>();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
                    String key = parser.currentName();
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
                    HashSet<String> values = new HashSet<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
                        values.add(parser.text());
                    }
                    contexts.put(key, values);
                }
                return contexts;
            }

            public static Option fromXContent(XContentParser parser) {
                Map values = (Map)PARSER.apply(parser, null);
                Text text = new Text((String)values.get(Suggest.Suggestion.Entry.Option.TEXT.getPreferredName()));
                Float score = (Float)values.get(Suggest.Suggestion.Entry.Option.SCORE.getPreferredName());
                Map<String, Set<String>> contexts = (Map<String, Set<String>>)values.get(CONTEXTS.getPreferredName());
                if (contexts == null) {
                    contexts = Collections.emptyMap();
                }
                SearchHit hit = null;
                if (score == null) {
                    hit = SearchHit.createFromMap(values);
                    score = Float.valueOf(hit.getScore());
                }
                Option option = new Option(-1, text, score.floatValue(), contexts);
                option.setHit(hit);
                return option;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                Lucene.writeScoreDoc(out, this.doc);
                if (this.hit != null) {
                    out.writeBoolean(true);
                    this.hit.writeTo(out);
                } else {
                    out.writeBoolean(false);
                }
                out.writeInt(this.contexts.size());
                for (Map.Entry<String, Set<String>> entry : this.contexts.entrySet()) {
                    out.writeString(entry.getKey());
                    out.writeVInt(entry.getValue().size());
                    for (CharSequence charSequence : entry.getValue()) {
                        out.writeString(charSequence.toString());
                    }
                }
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("text:");
                stringBuilder.append(this.getText());
                stringBuilder.append(" score:");
                stringBuilder.append(this.getScore());
                stringBuilder.append(" context:[");
                for (Map.Entry<String, Set<String>> entry : this.contexts.entrySet()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(entry.getValue());
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }

            static {
                SearchHit.declareInnerHitsParseFields(PARSER);
                PARSER.declareString((map, value) -> map.put(Suggest.Suggestion.Entry.Option.TEXT.getPreferredName(), value), Suggest.Suggestion.Entry.Option.TEXT);
                PARSER.declareFloat((map, value) -> map.put(Suggest.Suggestion.Entry.Option.SCORE.getPreferredName(), value), Suggest.Suggestion.Entry.Option.SCORE);
                PARSER.declareObject((map, value) -> map.put(CONTEXTS.getPreferredName(), value), (p, c) -> Option.parseContexts(p), CONTEXTS);
            }
        }
    }

    private static final class OptionPriorityQueue
    extends PriorityQueue<ShardOptions> {
        OptionPriorityQueue(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(ShardOptions a, ShardOptions b) {
            int compare = Suggest.COMPARATOR.compare(a.current, b.current);
            if (compare != 0) {
                return compare < 0;
            }
            ScoreDoc aDoc = a.current.getDoc();
            ScoreDoc bDoc = b.current.getDoc();
            if (aDoc.shardIndex == bDoc.shardIndex) {
                return aDoc.doc < bDoc.doc;
            }
            return aDoc.shardIndex < bDoc.shardIndex;
        }
    }

    private static class ShardOptions {
        final Iterator<Entry.Option> optionsIterator;
        Entry.Option current;

        private ShardOptions(Iterator<Entry.Option> optionsIterator) {
            assert (optionsIterator.hasNext());
            this.optionsIterator = optionsIterator;
            this.current = optionsIterator.next();
            assert (this.current.getDoc().shardIndex != -1) : "shardIndex is not set";
        }

        boolean advanceToNextOption() {
            if (this.optionsIterator.hasNext()) {
                this.current = this.optionsIterator.next();
                return true;
            }
            return false;
        }
    }
}

