/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ArtifactSelectionDetails;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dsl.ComponentSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ArtifactSelectionDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultArtifactSelectionDetails;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultDependencySubstitution
implements DependencySubstitutionInternal {
    private final ComponentSelector requested;
    private List<ComponentSelectionDescriptorInternal> ruleDescriptors;
    private ComponentSelector target;
    private final ArtifactSelectionDetailsInternal artifactSelectionDetails;

    @Inject
    public DefaultDependencySubstitution(ComponentSelector requested, List<IvyArtifactName> artifacts) {
        this.requested = requested;
        this.target = requested;
        this.artifactSelectionDetails = new DefaultArtifactSelectionDetails(this, artifacts);
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public void useTarget(Object notation) {
        this.useTarget(notation, ComponentSelectionReasons.SELECTED_BY_RULE);
    }

    public void useTarget(Object notation, String reason) {
        this.useTarget(notation, new DefaultComponentSelectionDescriptor(ComponentSelectionCause.SELECTED_BY_RULE, (Describable)Describables.of((Object)reason)));
    }

    public void artifactSelection(Action<? super ArtifactSelectionDetails> action) {
        action.execute((Object)this.artifactSelectionDetails);
    }

    @Override
    public void useTarget(Object notation, ComponentSelectionDescriptor ruleDescriptor) {
        this.target = (ComponentSelector)ComponentSelectorParsers.parser().parseNotation(notation);
        this.addRuleDescriptor((ComponentSelectionDescriptorInternal)ruleDescriptor);
        DefaultDependencySubstitution.validateTarget(this.target);
    }

    void addRuleDescriptor(ComponentSelectionDescriptorInternal ruleDescriptor) {
        if (this.ruleDescriptors == null) {
            this.ruleDescriptors = Lists.newArrayList();
        }
        this.ruleDescriptors.add(ruleDescriptor);
    }

    @Override
    public List<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
        return this.ruleDescriptors == null ? Collections.emptyList() : this.ruleDescriptors;
    }

    @Override
    public ComponentSelector getTarget() {
        return this.target;
    }

    @Override
    public boolean isUpdated() {
        return this.ruleDescriptors != null;
    }

    @Override
    public ArtifactSelectionDetailsInternal getArtifactSelectionDetails() {
        return this.artifactSelectionDetails;
    }

    public static void validateTarget(ComponentSelector componentSelector) {
        if (componentSelector instanceof UnversionedModuleComponentSelector) {
            throw new InvalidUserDataException("Must specify version for target of dependency substitution");
        }
    }
}

