/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.resources.ResourceLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Node
implements Comparable<Node> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Node.class);
    private ExecutionState state;
    private boolean dependenciesProcessed;
    private boolean allDependenciesComplete;
    private Throwable executionFailure;
    private final NavigableSet<Node> dependencySuccessors = Sets.newTreeSet();
    private final NavigableSet<Node> dependencyPredecessors = Sets.newTreeSet();
    private MutationInfo mutationInfo = new MutationInfo(this);

    public Node() {
        this.state = ExecutionState.UNKNOWN;
    }

    @VisibleForTesting
    ExecutionState getState() {
        return this.state;
    }

    public boolean isRequired() {
        return this.state == ExecutionState.SHOULD_RUN;
    }

    public boolean isMustNotRun() {
        return this.state == ExecutionState.MUST_NOT_RUN;
    }

    public boolean isIncludeInGraph() {
        return this.state != ExecutionState.NOT_REQUIRED && this.state != ExecutionState.UNKNOWN;
    }

    public boolean isReady() {
        return this.state == ExecutionState.SHOULD_RUN || this.state == ExecutionState.MUST_RUN;
    }

    public boolean isInKnownState() {
        return this.state != ExecutionState.UNKNOWN;
    }

    public boolean isComplete() {
        return this.state == ExecutionState.EXECUTED || this.state == ExecutionState.SKIPPED || this.state == ExecutionState.UNKNOWN || this.state == ExecutionState.NOT_REQUIRED || this.state == ExecutionState.MUST_NOT_RUN;
    }

    public boolean isSuccessful() {
        return this.state == ExecutionState.EXECUTED && !this.isFailed() || this.state == ExecutionState.NOT_REQUIRED || this.state == ExecutionState.MUST_NOT_RUN;
    }

    public boolean isFailed() {
        return this.getNodeFailure() != null || this.getExecutionFailure() != null;
    }

    public boolean isExecuted() {
        return this.state == ExecutionState.EXECUTED;
    }

    @Nullable
    public abstract Throwable getNodeFailure();

    public abstract void rethrowNodeFailure();

    public void startExecution(Consumer<Node> nodeStartAction) {
        assert (this.isReady());
        this.state = ExecutionState.EXECUTING;
        nodeStartAction.accept(this);
    }

    public void finishExecution(Consumer<Node> completionAction) {
        assert (this.state == ExecutionState.EXECUTING);
        this.state = ExecutionState.EXECUTED;
        completionAction.accept(this);
    }

    public void skipExecution(Consumer<Node> completionAction) {
        assert (this.state == ExecutionState.SHOULD_RUN);
        this.state = ExecutionState.SKIPPED;
        completionAction.accept(this);
    }

    public void abortExecution(Consumer<Node> completionAction) {
        assert (this.isReady());
        this.state = ExecutionState.SKIPPED;
        completionAction.accept(this);
    }

    public void require() {
        if (this.state != ExecutionState.SHOULD_RUN) {
            this.dependenciesProcessed = false;
            this.state = ExecutionState.SHOULD_RUN;
        }
    }

    public void doNotRequire() {
        this.state = ExecutionState.NOT_REQUIRED;
    }

    public void mustNotRun() {
        this.state = ExecutionState.MUST_NOT_RUN;
    }

    public void enforceRun() {
        assert (this.state == ExecutionState.SHOULD_RUN || this.state == ExecutionState.MUST_NOT_RUN || this.state == ExecutionState.MUST_RUN);
        this.state = ExecutionState.MUST_RUN;
    }

    public void setExecutionFailure(Throwable failure) {
        assert (this.state == ExecutionState.EXECUTING);
        this.executionFailure = failure;
    }

    @Nullable
    public Throwable getExecutionFailure() {
        return this.executionFailure;
    }

    public Set<Node> getDependencyPredecessors() {
        return this.dependencyPredecessors;
    }

    public Set<Node> getDependencySuccessors() {
        return this.dependencySuccessors;
    }

    public void addDependencySuccessor(Node toNode) {
        this.dependencySuccessors.add(toNode);
        toNode.getDependencyPredecessors().add(this);
    }

    @OverridingMethodsMustInvokeSuper
    protected boolean doCheckDependenciesComplete() {
        LOGGER.debug("Checking if all dependencies are complete for {}", (Object)this);
        for (Node dependency : this.dependencySuccessors) {
            if (dependency.isComplete()) continue;
            LOGGER.debug("Dependency {} for {} not yet completed", (Object)dependency, (Object)this);
            return false;
        }
        LOGGER.debug("All dependencies are complete for {}", (Object)this);
        return true;
    }

    public boolean updateAllDependenciesComplete() {
        if (!this.allDependenciesComplete) {
            this.forceAllDependenciesCompleteUpdate();
            return this.allDependenciesComplete;
        }
        return false;
    }

    public void forceAllDependenciesCompleteUpdate() {
        this.allDependenciesComplete = this.doCheckDependenciesComplete();
    }

    public boolean allDependenciesComplete() {
        return this.allDependenciesComplete;
    }

    public boolean allDependenciesSuccessful() {
        for (Node dependency : this.dependencySuccessors) {
            if (dependency.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    @OverridingMethodsMustInvokeSuper
    protected Iterable<Node> getAllPredecessors() {
        return this.getDependencyPredecessors();
    }

    public abstract void prepareForExecution();

    public abstract void resolveDependencies(TaskDependencyResolver var1, Action<Node> var2);

    public boolean getDependenciesProcessed() {
        return this.dependenciesProcessed;
    }

    public void dependenciesProcessed() {
        this.dependenciesProcessed = true;
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getAllSuccessors() {
        return this.dependencySuccessors;
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getAllSuccessorsInReverseOrder() {
        return this.dependencySuccessors.descendingSet();
    }

    @OverridingMethodsMustInvokeSuper
    public boolean hasHardSuccessor(Node successor) {
        return this.dependencySuccessors.contains(successor);
    }

    public abstract Set<Node> getFinalizers();

    public MutationInfo getMutationInfo() {
        return this.mutationInfo;
    }

    public abstract void resolveMutations();

    public abstract boolean isPublicNode();

    public abstract boolean requiresMonitoring();

    @Nullable
    public abstract ResourceLock getProjectToLock();

    @Nullable
    public abstract ProjectInternal getOwningProject();

    public abstract List<? extends ResourceLock> getResourcesToLock();

    public abstract String toString();

    @VisibleForTesting
    static enum ExecutionState {
        UNKNOWN,
        NOT_REQUIRED,
        SHOULD_RUN,
        MUST_RUN,
        MUST_NOT_RUN,
        EXECUTING,
        EXECUTED,
        SKIPPED;

    }
}

