/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

public class MavenDependencyCompletionUtil {
    public static MavenDomDependency findManagedDependency(MavenDomProjectModel domModel, Project project, @NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(1);
        }
        Ref ref = new Ref();
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(domModel, (Processor<? super MavenDomDependency>)((Processor)dependency -> {
            if (groupId.equals(dependency.getGroupId().getStringValue()) && artifactId.equals(dependency.getArtifactId().getStringValue())) {
                ref.set(dependency);
                return true;
            }
            return false;
        }), project);
        return (MavenDomDependency)ref.get();
    }

    public static boolean isInsideManagedDependency(@NotNull MavenDomShortArtifactCoordinates dependency) {
        DomElement parent;
        if (dependency == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(2);
        }
        if (!((parent = dependency.getParent()) instanceof MavenDomDependencies)) {
            return false;
        }
        return parent.getParent() instanceof MavenDomDependencyManagement;
    }

    public static void invokeCompletion(@NotNull InsertionContext context, CompletionType completionType) {
        if (context == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(3);
        }
        context.setLaterRunnable(() -> new CodeCompletionHandlerBase(completionType).invokeCompletion(context.getProject(), context.getEditor()));
    }

    public static LookupElementBuilder lookupElement(MavenDependencyCompletionItem item, String lookup) {
        return LookupElementBuilder.create((Object)item, (String)lookup).withIcon(MavenDependencyCompletionUtil.getIcon(item.getType()));
    }

    public static MavenDependencyCompletionItem getMaxIcon(MavenArtifactSearchResult searchResult) {
        return Collections.max(Arrays.asList(searchResult.getSearchResults().getItems()), Comparator.comparing(r -> {
            if (r.getType() == null) {
                return Integer.MIN_VALUE;
            }
            return r.getType().getWeight();
        }));
    }

    public static LookupElementBuilder lookupElement(MavenRepositoryArtifactInfo info) {
        return MavenDependencyCompletionUtil.lookupElement(info, MavenDependencyCompletionUtil.getPresentableText(info));
    }

    public static LookupElementBuilder lookupElement(MavenRepositoryArtifactInfo info, String presentableText) {
        LookupElementBuilder elementBuilder = LookupElementBuilder.create((Object)info, (String)MavenDependencyCompletionUtil.getLookupString(info.getItems()[0])).withPresentableText(presentableText);
        elementBuilder.putUserData(BaseCompletionLookupArranger.FORCE_MIDDLE_MATCH, new Object());
        if (info.getItems().length == 1) {
            return elementBuilder.withIcon(MavenDependencyCompletionUtil.getIcon(info.getItems()[0].getType()));
        }
        return elementBuilder;
    }

    public static String getPresentableText(MavenRepositoryArtifactInfo info) {
        if (info.getItems().length == 1) {
            return MavenDependencyCompletionUtil.getLookupString(info.getItems()[0]);
        }
        return IndicesBundle.message("maven.dependency.completion.presentable", info.getGroupId(), info.getArtifactId());
    }

    @Nullable
    public static Icon getIcon(@Nullable MavenDependencyCompletionItem.Type type) {
        if (type == MavenDependencyCompletionItem.Type.PROJECT) {
            return AllIcons.Nodes.Module;
        }
        return null;
    }

    public static String getLookupString(MavenDependencyCompletionItem description) {
        StringBuilder builder = new StringBuilder(description.getGroupId());
        if (description.getArtifactId() == null) {
            builder.append(":...");
        } else {
            builder.append(":").append(description.getArtifactId());
            if (description.getPackaging() != null) {
                builder.append(":").append(description.getPackaging());
            }
            if (description.getVersion() != null) {
                builder.append(":").append(description.getVersion());
            } else {
                builder.append(":...");
            }
        }
        return builder.toString();
    }

    @NotNull
    public static String removeDummy(@Nullable String str) {
        if (str == null) {
            return "";
        }
        String string = StringUtil.trim((String)str.replace("IntellijIdeaRulezzz ", "").replace(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED, ""));
        if (string == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDummy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findManagedDependency";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInsideManagedDependency";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeCompletion";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

