/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import icons.OpenapiIcons;
import javax.swing.Icon;

public class MavenPsiElementWrapper
extends RenameableFakePsiElement {
    private final PsiElement myWrappee;
    private final Navigatable myNavigatable;

    public MavenPsiElementWrapper(PsiElement wrappeeElement, Navigatable navigatable) {
        super(wrappeeElement.getParent());
        this.myWrappee = wrappeeElement;
        this.myNavigatable = navigatable;
    }

    public PsiElement getWrappee() {
        return this.myWrappee;
    }

    public PsiElement getParent() {
        return this.myWrappee.getParent();
    }

    public String getName() {
        return ((PsiNamedElement)this.myWrappee).getName();
    }

    public void navigate(boolean requestFocus) {
        this.myNavigatable.navigate(requestFocus);
    }

    public String getTypeName() {
        return "Property";
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public TextRange getTextRange() {
        return this.myWrappee.getTextRange();
    }

    public boolean isEquivalentTo(PsiElement other) {
        if (other instanceof MavenPsiElementWrapper) {
            return this.myWrappee == ((MavenPsiElementWrapper)other).myWrappee;
        }
        return this.myWrappee == other;
    }
}

