/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Consumer;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.BuildViewMavenConsole;
import org.jetbrains.idea.maven.execution.MavenExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenSpyOutputParser;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;

@Deprecated
public class MavenExternalExecutor
extends MavenExecutor {
    private OSProcessHandler myProcessHandler;
    @NonNls
    private static final String PHASE_INFO_REGEXP = "\\[INFO\\] \\[.*:.*\\]";
    @NonNls
    private static final int INFO_PREFIX_SIZE = "[INFO] ".length();
    private JavaParameters myJavaParameters;
    private ExecutionException myParameterCreationError;

    public MavenExternalExecutor(Project project, @NotNull MavenRunnerParameters parameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @NotNull MavenConsole console) {
        if (parameters == null) {
            MavenExternalExecutor.$$$reportNull$$$0(0);
        }
        if (console == null) {
            MavenExternalExecutor.$$$reportNull$$$0(1);
        }
        super(parameters, RunnerBundle.message("external.executor.caption", new Object[0]), console);
        try {
            this.myJavaParameters = MavenExternalParameters.createJavaParameters(project, this.myParameters, coreSettings, runnerSettings, null);
        }
        catch (ExecutionException e) {
            this.myParameterCreationError = e;
        }
    }

    @Override
    public boolean execute(ProgressIndicator indicator) {
        this.displayProgress();
        try {
            if (this.myParameterCreationError != null) {
                throw this.myParameterCreationError;
            }
            this.myProcessHandler = new MyLineSplittingProcessHandler(this.myJavaParameters.toCommandLine(), this.myConsole, (Consumer<String>)((Consumer)line -> this.updateProgress(indicator, (String)line)));
            this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        }
        catch (ExecutionException e) {
            this.myConsole.systemMessage(4, RunnerBundle.message("external.startup.failed", e.getMessage()), null);
            return false;
        }
        this.start();
        this.readProcessOutput();
        this.stop();
        return this.printExitSummary();
    }

    @Override
    void stop() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.destroyProcess();
            this.myProcessHandler.waitFor();
            this.setExitCode(this.myProcessHandler.getProcess().exitValue());
        }
        super.stop();
    }

    private void readProcessOutput() {
        this.myProcessHandler.startNotify();
        this.myProcessHandler.waitFor();
    }

    private void updateProgress(@Nullable ProgressIndicator indicator, String text) {
        if (indicator != null) {
            if (indicator.isCanceled() && !this.isCancelled()) {
                ApplicationManager.getApplication().invokeLater(() -> this.cancel());
            }
            if (text.matches(PHASE_INFO_REGEXP)) {
                indicator.setText2(text.substring(INFO_PREFIX_SIZE));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "console";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/execution/MavenExternalExecutor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MavenSimpleConsoleEventsBuffer {
        private final StringBuilder myBuffer = new StringBuilder();
        private final BiConsumer<String, Key> myConsumer;
        private final boolean myShowSpyOutput;
        private boolean isProcessingSpyNow;

        public MavenSimpleConsoleEventsBuffer(BiConsumer<String, Key> consumer, boolean showSpyOutput) {
            this.myConsumer = consumer;
            this.myShowSpyOutput = showSpyOutput;
        }

        public void addText(@NotNull String text, @NotNull Key outputType) {
            String textToSend;
            boolean lastChunk;
            if (text == null) {
                MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(1);
            }
            if (this.myShowSpyOutput) {
                this.myConsumer.accept(text, outputType);
                return;
            }
            boolean bl = lastChunk = text.charAt(text.length() - 1) == '\n';
            if (this.isProcessingSpyNow) {
                this.myBuffer.setLength(0);
                this.isProcessingSpyNow = !lastChunk;
                return;
            }
            String string = textToSend = this.myBuffer.length() == 0 ? text : this.myBuffer + text;
            if (textToSend.length() >= "[IJ]-".length() || lastChunk) {
                this.myBuffer.setLength(0);
                if (!MavenSpyOutputParser.isSpyLog(textToSend)) {
                    this.myConsumer.accept(textToSend, outputType);
                } else {
                    this.isProcessingSpyNow = !lastChunk;
                }
            } else {
                this.myBuffer.append(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/execution/MavenExternalExecutor$MavenSimpleConsoleEventsBuffer";
            objectArray[2] = "addText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MavenSpyEventsBuffer {
        private final StringBuilder myBuffer = new StringBuilder();
        private final BiConsumer<String, Key> myConsumer;

        public MavenSpyEventsBuffer(BiConsumer<String, Key> consumer) {
            this.myConsumer = consumer;
        }

        public void addText(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MavenSpyEventsBuffer.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                MavenSpyEventsBuffer.$$$reportNull$$$0(1);
            }
            if (text.charAt(text.length() - 1) == '\n') {
                String textToSend = this.myBuffer.length() == 0 ? text : this.myBuffer + text;
                this.myConsumer.accept(textToSend, outputType);
                this.myBuffer.setLength(0);
            } else {
                this.myBuffer.append(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/execution/MavenExternalExecutor$MavenSpyEventsBuffer";
            objectArray[2] = "addText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyLineSplittingProcessHandler
    extends OSProcessHandler {
        private final MavenSpyEventsBuffer mySpyEventsBuffer;
        private final MavenSimpleConsoleEventsBuffer mySimpleConsoleEventsBuffer;
        @NotNull
        private final MavenConsole myConsole;
        private final AnsiEscapeDecoder myDecoder;
        @Nullable
        private final Consumer<String> myProgressConsumer;

        MyLineSplittingProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull MavenConsole console, @Nullable Consumer<String> progressConsumer) throws ExecutionException {
            if (commandLine == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(0);
            }
            if (console == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(1);
            }
            super(commandLine);
            this.myDecoder = new AnsiEscapeDecoder();
            this.myProgressConsumer = progressConsumer;
            this.myConsole = console;
            this.mySpyEventsBuffer = new MavenSpyEventsBuffer((line, key) -> {
                this.sendToMavenEventParser((String)line, (Key)key);
                if (this.myProgressConsumer != null) {
                    this.myProgressConsumer.consume(line);
                }
            });
            this.mySimpleConsoleEventsBuffer = new MavenSimpleConsoleEventsBuffer((line, key) -> this.printSimpleOutput((String)line, (Key)key), Registry.is((String)"maven.spy.events.debug"));
        }

        public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(2);
            }
            if (outputType == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(3);
            }
            this.mySpyEventsBuffer.addText(text, outputType);
            this.mySimpleConsoleEventsBuffer.addText(text, outputType);
        }

        private void sendToMavenEventParser(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(4);
            }
            if (outputType == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(5);
            }
            if (this.myConsole instanceof BuildViewMavenConsole) {
                ((BuildViewMavenConsole)this.myConsole).sendToEventParser(text, outputType);
            }
        }

        private void printSimpleOutput(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(6);
            }
            if (outputType == null) {
                MyLineSplittingProcessHandler.$$$reportNull$$$0(7);
            }
            if (!this.myConsole.isSuppressed(text)) {
                this.myDecoder.escapeText(text, outputType, (t, ot) -> super.notifyTextAvailable(t, ot));
            }
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return new BaseOutputReader.Options(){

                public BaseDataReader.SleepingPolicy policy() {
                    return BaseDataReader.SleepingPolicy.BLOCKING;
                }

                public boolean splitToLines() {
                    return true;
                }

                public boolean sendIncompleteLines() {
                    return true;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenExternalExecutor$MyLineSplittingProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyTextAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sendToMavenEventParser";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printSimpleOutput";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

