/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;

public abstract class MessageNotifier
implements MavenLoggedEventParser {
    @NotNull
    private final LogMessageType myType;
    @NotNull
    private final MessageEvent.Kind myKind;
    @NotNull
    private final String myGroup;
    private final Set<String> myMessages;

    protected MessageNotifier(@NotNull LogMessageType type, @NotNull MessageEvent.Kind kind, @NotNull String group) {
        if (type == null) {
            MessageNotifier.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            MessageNotifier.$$$reportNull$$$0(1);
        }
        if (group == null) {
            MessageNotifier.$$$reportNull$$$0(2);
        }
        this.myMessages = new HashSet<String>();
        this.myType = type;
        this.myKind = kind;
        this.myGroup = group;
    }

    @Override
    public boolean supportsType(@Nullable LogMessageType type) {
        return type == this.myType;
    }

    @Override
    public boolean checkLogLine(@NotNull Object parendId, @NotNull MavenLogEntryReader.MavenLogEntry logLine, @NotNull MavenLogEntryReader logEntryReader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (parendId == null) {
            MessageNotifier.$$$reportNull$$$0(3);
        }
        if (logLine == null) {
            MessageNotifier.$$$reportNull$$$0(4);
        }
        if (logEntryReader == null) {
            MessageNotifier.$$$reportNull$$$0(5);
        }
        if (messageConsumer == null) {
            MessageNotifier.$$$reportNull$$$0(6);
        }
        String line = logLine.getLine();
        List<MavenLogEntryReader.MavenLogEntry> toConcat = logEntryReader.readWhile(l -> l.getType() == this.myType);
        String contatenated = line + "\n" + StringUtil.join(toConcat, MavenLogEntryReader.MavenLogEntry::getLine, (String)"\n");
        String message = this.getMessage(line, toConcat);
        if (!StringUtil.isEmptyOrSpaces((String)message) && this.myMessages.add(message)) {
            messageConsumer.accept((BuildEvent)new MessageEventImpl(parendId, this.myKind, this.myGroup, message, contatenated));
            return true;
        }
        return false;
    }

    @NotNull
    protected String getMessage(String line, List<MavenLogEntryReader.MavenLogEntry> toConcat) {
        if (toConcat == null || toConcat.isEmpty()) {
            String string = line;
            if (string == null) {
                MessageNotifier.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (!StringUtil.isEmptyOrSpaces((String)line)) {
            String string = line;
            if (string == null) {
                MessageNotifier.$$$reportNull$$$0(8);
            }
            return string;
        }
        MavenLogEntryReader.MavenLogEntry entry = (MavenLogEntryReader.MavenLogEntry)ContainerUtil.find(toConcat, e -> !StringUtil.isEmptyOrSpaces((String)e.getLine()));
        if (entry != null) {
            String string = entry.getLine();
            if (string == null) {
                MessageNotifier.$$$reportNull$$$0(9);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parendId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntryReader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MessageNotifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MessageNotifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkLogLine";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

