/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "()V", "builder", "Lorg/jetbrains/idea/maven/wizards/MavenProjectBuilder;", "getBuilder", "()Lorg/jetbrains/idea/maven/wizards/MavenProjectBuilder;", "isProjectFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "linkAndRefreshProject", "", "projectDirectory", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenOpenProjectProvider
extends AbstractOpenProjectProvider {
    @NotNull
    public final MavenProjectBuilder getBuilder() {
        Object object = ProjectImportBuilder.EXTENSIONS_POINT_NAME.findExtensionOrFail(MavenProjectBuilder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ProjectImportBuilder.EXT\u2026ojectBuilder::class.java)");
        return (MavenProjectBuilder)((Object)object);
    }

    protected boolean isProjectFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return MavenUtil.isPomFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void linkAndRefreshProject(@NotNull Path projectDirectory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        MavenProjectBuilder builder = this.getBuilder();
        try {
            builder.setUpdate(false);
            builder.setFileToImport(projectDirectory);
            if (builder.validate(null, project)) {
                builder.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
        }
        finally {
            builder.cleanup();
        }
    }
}

