/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.DeprecatedProjectBuilderForImport;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import icons.OpenapiIcons;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;
import org.jetbrains.idea.maven.utils.FileFinder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenProjectOpenProcessor;

public final class MavenProjectBuilder
extends ProjectImportBuilder<MavenProject>
implements DeprecatedProjectBuilderForImport {
    private static final Logger LOG = Logger.getInstance(MavenProjectBuilder.class);
    private Parameters myParameters;

    @NotNull
    public String getName() {
        String string = MavenProjectBundle.message("maven.name", new Object[0]);
        if (string == null) {
            MavenProjectBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public void cleanup() {
        this.myParameters = null;
        super.cleanup();
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    private Parameters getParameters() {
        if (this.myParameters == null) {
            this.myParameters = new Parameters();
        }
        return this.myParameters;
    }

    private boolean setupProjectImport(@NotNull Project project) {
        Path rootDirectory;
        if (project == null) {
            MavenProjectBuilder.$$$reportNull$$$0(1);
        }
        return (rootDirectory = this.getRootPath()) != null && this.setRootDirectory(project, rootDirectory) && this.selectProjectsToUpdate();
    }

    private boolean selectProjectsToUpdate() {
        Parameters parameters = this.getParameters();
        MavenProjectsTree projectsTree = parameters.myMavenProjectTree;
        List<MavenProject> projects = projectsTree.getRootProjects();
        if (projects.isEmpty()) {
            return false;
        }
        parameters.mySelectedProjects = projects;
        return true;
    }

    private void setupProjectName(@NotNull Project project) {
        if (project == null) {
            MavenProjectBuilder.$$$reportNull$$$0(2);
        }
        if (!(project instanceof ProjectEx)) {
            return;
        }
        String projectName = this.getSuggestedProjectName();
        if (projectName != null) {
            ((ProjectEx)project).setProjectName(projectName);
        }
    }

    @Nullable
    public Sdk suggestProjectSdk() {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        ProjectRootManager defaultProjectManager = ProjectRootManager.getInstance((Project)defaultProject);
        Sdk defaultProjectSdk = defaultProjectManager.getProjectSdk();
        if (defaultProjectSdk != null) {
            return null;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        return projectJdkTable.getSdksOfType((SdkTypeId)sdkType).stream().filter(it -> it.getHomePath() != null && JdkUtil.checkForJre((String)it.getHomePath())).max(sdkType.versionComparator()).orElse(null);
    }

    private void setupProjectSdk(@NotNull Project project) {
        if (project == null) {
            MavenProjectBuilder.$$$reportNull$$$0(3);
        }
        if (ProjectRootManager.getInstance((Project)project).getProjectSdk() == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Sdk projectSdk = this.suggestProjectSdk();
                if (projectSdk == null) {
                    return;
                }
                NewProjectUtil.applyJdkToProject((Project)project, (Sdk)projectSdk);
            });
        }
    }

    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        boolean isFromUI;
        if (!this.setupProjectImport(project)) {
            LOG.debug(String.format("Cannot import project for %s", project.toString()));
            return Collections.emptyList();
        }
        this.setupProjectName(project);
        this.setupProjectSdk(project);
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
        settings.generalSettings = this.getGeneralSettings();
        settings.importingSettings = this.getImportingSettings();
        String settingsFile = System.getProperty("idea.maven.import.settings.file");
        if (!StringUtil.isEmptyOrSpaces((String)settingsFile)) {
            settings.generalSettings.setUserSettingsFile(settingsFile.trim());
        }
        MavenExplicitProfiles selectedProfiles = MavenExplicitProfiles.NONE.clone();
        String enabledProfilesList = System.getProperty("idea.maven.import.enabled.profiles");
        String disabledProfilesList = System.getProperty("idea.maven.import.disabled.profiles");
        if (enabledProfilesList != null || disabledProfilesList != null) {
            MavenProjectBuilder.appendProfilesFromString(selectedProfiles.getEnabledProfiles(), enabledProfilesList);
            MavenProjectBuilder.appendProfilesFromString(selectedProfiles.getDisabledProfiles(), disabledProfilesList);
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        manager.setIgnoredState(this.getParameters().mySelectedProjects, false);
        manager.addManagedFilesWithProfiles(MavenUtil.collectFiles(this.getParameters().mySelectedProjects), selectedProfiles);
        manager.waitForReadingCompletion();
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            Promise<List<Module>> promise = manager.scheduleImportAndResolve();
            manager.waitForResolvingCompletion();
            try {
                return (List)promise.blockingGet(0);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        boolean bl = isFromUI = model != null;
        if (isFromUI) {
            return manager.importProjects((IdeModifiableModelsProvider)new IdeUIModifiableModelsProvider(project, model, (ModulesConfigurator)modulesProvider, artifactModel));
        }
        return manager.importProjects();
    }

    private static void appendProfilesFromString(Collection<String> selectedProfiles, String profilesList) {
        if (profilesList == null) {
            return;
        }
        for (String profile : StringUtil.split((String)profilesList, (String)",")) {
            String trimmedProfileName = profile.trim();
            if (trimmedProfileName.isEmpty()) continue;
            selectedProfiles.add(trimmedProfileName);
        }
    }

    @Deprecated
    public boolean setRootDirectory(@Nullable Project projectToUpdate, @NotNull String root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(4);
        }
        return this.setRootDirectory(projectToUpdate, Paths.get(root, new String[0]));
    }

    public boolean setRootDirectory(@Nullable Project projectToUpdate, final @NotNull Path root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(5);
        }
        this.getParameters().myFiles = null;
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().myProjectToUpdate = projectToUpdate != null ? projectToUpdate : ProjectManager.getInstance().getDefaultProject();
        return MavenProjectBuilder.runConfigurationProcess(MavenProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                VirtualFile virtualFile;
                indicator.setText(MavenProjectBundle.message("maven.locating.files", new Object[0]));
                MavenProjectBuilder.this.getParameters().myImportRoot = root;
                if (MavenProjectBuilder.this.getParameters().myImportRoot == null) {
                    throw new MavenProcessCanceledException();
                }
                Path file = MavenProjectBuilder.this.getRootPath();
                VirtualFile virtualFile2 = virtualFile = file == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file.toString()));
                if (virtualFile == null) {
                    throw new MavenProcessCanceledException();
                }
                MavenProjectBuilder.this.getParameters().myFiles = FileFinder.findPomFiles(virtualFile.getChildren(), LookForNestedToggleAction.isSelected(), indicator, new ArrayList<VirtualFile>());
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText("");
                indicator.setText2("");
            }
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public boolean setSelectedProfiles(MavenExplicitProfiles profiles) {
        return MavenProjectBuilder.runConfigurationProcess(MavenProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) {
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText2("");
            }
        });
    }

    private static boolean runConfigurationProcess(String message, MavenTask p) {
        try {
            MavenUtil.run(null, message, p);
        }
        catch (MavenProcessCanceledException e) {
            return false;
        }
        return true;
    }

    private void readMavenProjectTree(MavenProgressIndicator process2) {
        MavenProjectsTree tree = new MavenProjectsTree(this.getProjectOrDefault());
        tree.addManagedFilesWithProfiles(this.getParameters().myFiles, MavenExplicitProfiles.NONE);
        tree.updateAll(false, this.getGeneralSettings(), process2);
        this.getParameters().myMavenProjectTree = tree;
        this.getParameters().mySelectedProjects = tree.getRootProjects();
    }

    public List<MavenProject> getList() {
        return this.getParameters().myMavenProjectTree.getRootProjects();
    }

    public void setList(List<MavenProject> projects) {
        this.getParameters().mySelectedProjects = projects;
    }

    public boolean isMarked(MavenProject element) {
        return this.getParameters().mySelectedProjects.contains(element);
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().myOpenModulesConfigurator;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().myOpenModulesConfigurator = on;
    }

    public MavenGeneralSettings getGeneralSettings() {
        if (this.getParameters().myGeneralSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> this.getParameters().myGeneralSettingsCache = this.getDirectProjectsSettings().generalSettings.clone());
        }
        return this.getParameters().myGeneralSettingsCache;
    }

    public MavenImportingSettings getImportingSettings() {
        if (this.getParameters().myImportingSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> this.getParameters().myImportingSettingsCache = this.getDirectProjectsSettings().importingSettings.clone());
        }
        return this.getParameters().myImportingSettingsCache;
    }

    private MavenWorkspaceSettings getDirectProjectsSettings() {
        Project project;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = project = this.isUpdate() ? this.getProjectToUpdate() : null;
        if (project == null || project.isDisposed()) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
    }

    public void setFiles(List<VirtualFile> files) {
        this.getParameters().myFiles = files;
    }

    @Nullable
    public Project getProjectToUpdate() {
        if (this.getParameters().myProjectToUpdate == null) {
            this.getParameters().myProjectToUpdate = MavenProjectBuilder.getCurrentProject();
        }
        return this.getParameters().myProjectToUpdate;
    }

    @NotNull
    public Project getProjectOrDefault() {
        Project project = this.getProjectToUpdate();
        if (project == null || project.isDisposed()) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        if (project2 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(6);
        }
        return project2;
    }

    @Deprecated
    @Nullable
    public VirtualFile getRootDirectory() {
        Path rootPath = this.getRootPath();
        return rootPath == null ? null : VfsUtil.findFile((Path)rootPath, (boolean)false);
    }

    @Nullable
    public Path getRootPath() {
        if (this.getParameters().myImportRoot == null && this.isUpdate()) {
            Project project = this.getProjectToUpdate();
            this.getParameters().myImportRoot = project == null ? null : Paths.get(Objects.requireNonNull(project.getBasePath()), new String[0]);
        }
        return this.getParameters().myImportRoot;
    }

    @Nullable
    public String getSuggestedProjectName() {
        List<MavenProject> list = this.getParameters().myMavenProjectTree.getRootProjects();
        return list.size() == 1 ? list.get(0).getMavenId().getArtifactId() : null;
    }

    public void setFileToImport(@NotNull String path) {
        if (path == null) {
            MavenProjectBuilder.$$$reportNull$$$0(7);
        }
        this.setFileToImport(Paths.get(path, new String[0]));
    }

    public void setFileToImport(@NotNull Path path) {
        if (path == null) {
            MavenProjectBuilder.$$$reportNull$$$0(8);
        }
        this.getParameters().myImportRoot = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ExternalProjectsManagerImpl.setupCreatedProject((Project)super.createProject(name, path));
    }

    @NotNull
    public ProjectOpenProcessor getProjectOpenProcessor() {
        ProjectOpenProcessor projectOpenProcessor = (ProjectOpenProcessor)ProjectOpenProcessor.EXTENSION_POINT_NAME.findExtensionOrFail(MavenProjectOpenProcessor.class);
        if (projectOpenProcessor == null) {
            MavenProjectBuilder.$$$reportNull$$$0(9);
        }
        return projectOpenProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrDefault";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOpenProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectImport";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectSdk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRootDirectory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFileToImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Parameters {
        private Project myProjectToUpdate;
        private MavenGeneralSettings myGeneralSettingsCache;
        private MavenImportingSettings myImportingSettingsCache;
        private Path myImportRoot;
        private List<VirtualFile> myFiles;
        private MavenProjectsTree myMavenProjectTree;
        private List<MavenProject> mySelectedProjects;
        private boolean myOpenModulesConfigurator;

        private Parameters() {
        }
    }
}

