/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en.avs;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedToken;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.avs.AvsAnRule;
import org.languagetool.rules.en.avs.AvsAnRule$WhenMappings;
import org.languagetool.rules.en.avs.AvsAnRuleKt;
import org.languagetool.tools.StringTools;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e\u00a8\u0006\u001e"}, d2={"Lorg/languagetool/rules/en/avs/AvsAnRule;", "Lorg/languagetool/rules/Rule;", "messages", "Ljava/util/ResourceBundle;", "language", "Lorg/languagetool/language/Language;", "(Ljava/util/ResourceBundle;Lorg/languagetool/language/Language;)V", "estimateContextForSureMatch", "", "getCorrectDeterminerFor", "Lorg/languagetool/rules/en/avs/AvsAnRule$Determiner;", "token", "Lorg/languagetool/analysis/AnalyzedTokenReadings;", "getDescription", "", "getId", "isVowel", "", "c", "", "match", "", "Lorg/languagetool/rules/RuleMatch;", "sentence", "Lorg/languagetool/analysis/AnalyzedSentence;", "(Lorg/languagetool/analysis/AnalyzedSentence;)[Lorg/languagetool/rules/RuleMatch;", "suggestAorAn", "origWord", "Companion", "Determiner", "en"})
public final class AvsAnRule
extends Rule {
    @NotNull
    private static final Set<String> wordsRequiringA;
    @NotNull
    private static final Set<String> wordsRequiringAn;
    private static final Pattern cleanupPattern;
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return "EN_A_VS_AN";
    }

    @NotNull
    public String getDescription() {
        return "Use of 'a' vs. 'an'";
    }

    public int estimateContextForSureMatch() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RuleMatch[] match(@NotNull AnalyzedSentence sentence) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        Object[] tokens = sentence.getTokensWithoutWhitespace();
        int prevTokenIndex = 0;
        for (IndexedValue indexedValue : CollectionsKt.drop((Iterable)ArraysKt.withIndex((Object[])tokens), (int)1)) {
            boolean equalsAn;
            boolean bl;
            boolean isSentenceStart;
            int n = indexedValue.component1();
            AnalyzedTokenReadings token = (AnalyzedTokenReadings)indexedValue.component2();
            String prevTokenStr = prevTokenIndex > 0 ? tokens[prevTokenIndex].getToken() : null;
            boolean bl2 = isSentenceStart = prevTokenIndex == 1;
            if (!isSentenceStart) {
                bl = Intrinsics.areEqual((Object)"a", (Object)prevTokenStr);
            } else {
                String string = prevTokenStr;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                bl = StringsKt.equals((String)"a", (String)string, (boolean)true);
            }
            boolean equalsA = bl;
            boolean bl3 = equalsAn = !isSentenceStart ? Intrinsics.areEqual((Object)"an", (Object)prevTokenStr) : StringsKt.equals((String)"an", (String)prevTokenStr, (boolean)true);
            if (equalsA || equalsAn) {
                String msg;
                String string;
                Determiner determiner = this.getCorrectDeterminerFor(token);
                if (equalsA && determiner == Determiner.AN) {
                    String replacement = StringTools.startsWithUppercase((String)prevTokenStr) ? "An" : "an";
                    string = "Use <suggestion>" + replacement + "</suggestion> instead of '" + prevTokenStr + "' if the following " + "word starts with a vowel sound, e.g. 'an article', 'an hour'";
                } else if (equalsAn && determiner == Determiner.A) {
                    String replacement = StringTools.startsWithUppercase((String)prevTokenStr) ? "A" : "a";
                    string = "Use <suggestion>" + replacement + "</suggestion> instead of '" + prevTokenStr + "' if the following " + "word doesn't start with a vowel sound, e.g. 'a sentence', 'a university'";
                } else {
                    string = msg = null;
                }
                if (msg != null) {
                    ruleMatches.add(new RuleMatch((Rule)this, sentence, tokens[prevTokenIndex].getStartPos(), tokens[prevTokenIndex].getEndPos(), tokens[prevTokenIndex].getStartPos(), token.getEndPos(), msg, "Wrong article"));
                }
            }
            if (token.hasPosTag("DT")) {
                void i;
                prevTokenIndex = i;
                continue;
            }
            CharSequence charSequence = token.getToken();
            String string = "[-\"()\\[\\]]+";
            boolean bl4 = false;
            string = new Regex(string);
            bl4 = false;
            if (string.matches(charSequence)) continue;
            prevTokenIndex = 0;
        }
        RuleMatch[] ruleMatchArray = this.toRuleMatchArray(ruleMatches);
        Intrinsics.checkExpressionValueIsNotNull((Object)ruleMatchArray, (String)"toRuleMatchArray(ruleMatches)");
        return ruleMatchArray;
    }

    @NotNull
    public final String suggestAorAn(@NotNull String origWord) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)origWord, (String)"origWord");
        switch (AvsAnRule$WhenMappings.$EnumSwitchMapping$0[this.getCorrectDeterminerFor(new AnalyzedTokenReadings(new AnalyzedToken(origWord, null, null), 0)).ordinal()]) {
            case 1: 
            case 2: {
                string = "a " + AvsAnRuleKt.decapitalizeIfNotAbbreviation(origWord);
                break;
            }
            case 3: {
                string = "an " + AvsAnRuleKt.decapitalizeIfNotAbbreviation(origWord);
                break;
            }
            default: {
                string = origWord;
            }
        }
        return string;
    }

    @NotNull
    public final Determiner getCorrectDeterminerFor(@NotNull AnalyzedTokenReadings token) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        String word = token.getToken();
        Determiner determiner = Determiner.UNKNOWN;
        CharSequence charSequence = word;
        String string = "[-']";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Object $this$toTypedArray$iv = (String[])list;
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        $this$toTypedArray$iv = parts;
        boolean bl4 = false;
        String[] stringArray2 = $this$toTypedArray$iv;
        boolean bl5 = false;
        if (!(stringArray2.length == 0) && !StringsKt.equals((String)parts[0], (String)"a", (boolean)true)) {
            word = parts[0];
        }
        if (token.isWhitespaceBefore() || Intrinsics.areEqual((Object)"-", (Object)word) ^ true) {
            String string2 = cleanupPattern.matcher(word).replaceAll("");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cleanupPattern.matcher(word).replaceAll(\"\")");
            word = string2;
            if (StringTools.isEmpty((String)word)) {
                return Determiner.UNKNOWN;
            }
        }
        $this$toTypedArray$iv = word;
        Set<String> set = wordsRequiringA;
        bl4 = false;
        Object object = $this$toTypedArray$iv;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        if (set.contains(string4) || wordsRequiringA.contains(word)) {
            determiner = Determiner.A;
        }
        $this$toTypedArray$iv = word;
        set = wordsRequiringAn;
        bl4 = false;
        Object object2 = $this$toTypedArray$iv;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = ((String)object2).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        string4 = string5;
        if (set.contains(string4) || wordsRequiringAn.contains(word)) {
            Determiner determiner2 = determiner = determiner == Determiner.A ? Determiner.A_OR_AN : Determiner.AN;
        }
        if (determiner == Determiner.UNKNOWN) {
            char tokenFirstChar = word.charAt(0);
            determiner = StringTools.isAllUppercase((String)word) || StringTools.isMixedCase((String)word) ? Determiner.UNKNOWN : (this.isVowel(tokenFirstChar) ? Determiner.AN : Determiner.A);
        }
        return determiner;
    }

    private final boolean isVowel(char c) {
        char lc = Character.toLowerCase(c);
        return lc == 'a' || lc == 'e' || lc == 'i' || lc == 'o' || lc == 'u';
    }

    public AvsAnRule(@NotNull ResourceBundle messages, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        super(messages, language);
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"The train arrived <marker>a hour</marker> ago."), Example.fixed((String)"The train arrived <marker>an hour</marker> ago."));
    }

    static {
        Companion = new Companion(null);
        wordsRequiringA = AvsAnRule.Companion.loadWords("/en/det_a.txt");
        wordsRequiringAn = AvsAnRule.Companion.loadWords("/en/det_an.txt");
        cleanupPattern = Pattern.compile("[^\u03b1a-zA-Z0-9.;,:']");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/languagetool/rules/en/avs/AvsAnRule$Determiner;", "", "(Ljava/lang/String;I)V", "A", "AN", "A_OR_AN", "UNKNOWN", "en"})
    public static final class Determiner
    extends Enum<Determiner> {
        public static final /* enum */ Determiner A;
        public static final /* enum */ Determiner AN;
        public static final /* enum */ Determiner A_OR_AN;
        public static final /* enum */ Determiner UNKNOWN;
        private static final /* synthetic */ Determiner[] $VALUES;

        static {
            Determiner[] determinerArray = new Determiner[4];
            Determiner[] determinerArray2 = determinerArray;
            determinerArray[0] = A = new Determiner();
            determinerArray[1] = AN = new Determiner();
            determinerArray[2] = A_OR_AN = new Determiner();
            determinerArray[3] = UNKNOWN = new Determiner();
            $VALUES = determinerArray;
        }

        public static Determiner[] values() {
            return (Determiner[])$VALUES.clone();
        }

        public static Determiner valueOf(String string) {
            return Enum.valueOf(Determiner.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/languagetool/rules/en/avs/AvsAnRule$Companion;", "", "()V", "cleanupPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "wordsRequiringA", "", "", "getWordsRequiringA", "()Ljava/util/Set;", "wordsRequiringAn", "getWordsRequiringAn", "loadWords", "path", "en"})
    public static final class Companion {
        @NotNull
        public final Set<String> getWordsRequiringA() {
            return wordsRequiringA;
        }

        @NotNull
        public final Set<String> getWordsRequiringAn() {
            return wordsRequiringAn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Set<String> loadWords(String path) {
            Set set;
            InputStream inputStream = JLanguageTool.Companion.getDataBroker().getFromRulesDirAsStream(path);
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            boolean $i$f$useLines = false;
            Closeable closeable2 = $this$useLines$iv;
            int n2 = 8192;
            n = 0;
            closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
            n2 = 0;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable2;
                boolean bl3 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)lines, (Function1)loadWords.1.1.INSTANCE), (Function1)loadWords.1.2.INSTANCE), (Function1)loadWords.1.3.INSTANCE));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            return set;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

