/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeUtil {
    private static final Logger LOG = Logger.getInstance(GitMergeUtil.class);
    static final int ORIGINAL_REVISION_NUM = 1;
    static final int YOURS_REVISION_NUM = 2;
    static final int THEIRS_REVISION_NUM = 3;

    private GitMergeUtil() {
    }

    @NonNls
    public static String[] getMergeStrategies(int branchCount) {
        if (branchCount < 0) {
            throw new IllegalArgumentException("Branch count must be non-negative: " + branchCount);
        }
        switch (branchCount) {
            case 0: {
                return new String[]{GitMergeUtil.getDefaultStrategy()};
            }
            case 1: {
                return new String[]{GitMergeUtil.getDefaultStrategy(), "resolve", "recursive", "octopus", "ours", "subtree"};
            }
        }
        return new String[]{GitMergeUtil.getDefaultStrategy(), "octopus", "ours"};
    }

    public static void setupStrategies(final ElementsChooser<String> branchChooser, final JComboBox strategy) {
        ElementsChooser.ElementsMarkListener<String> listener = new ElementsChooser.ElementsMarkListener<String>(){

            private void updateStrategies(List<String> elements) {
                strategy.removeAllItems();
                for (String s : GitMergeUtil.getMergeStrategies(elements.size())) {
                    strategy.addItem(s);
                }
                strategy.setSelectedItem(GitMergeUtil.getDefaultStrategy());
            }

            public void elementMarkChanged(String element, boolean isMarked) {
                List elements = branchChooser.getMarkedElements();
                strategy.setEnabled(!elements.isEmpty());
                this.updateStrategies(elements);
            }
        };
        listener.elementMarkChanged(null, true);
        branchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)listener);
    }

    public static MergeData loadMergeData(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, boolean isReversed) throws VcsException {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(1);
        }
        if (path == null) {
            GitMergeUtil.$$$reportNull$$$0(2);
        }
        byte[] originalContent = GitMergeUtil.loadOriginalContent(project, root, path);
        byte[] yoursContent = GitMergeUtil.loadRevisionCatchingErrors(project, root, path, 2);
        byte[] theirsContent = GitMergeUtil.loadRevisionCatchingErrors(project, root, path, 3);
        GitRevisionNumber yoursRevision = GitMergeUtil.resolveHead(project, root);
        GitRevisionNumber theirsRevision = GitMergeUtil.resolveMergeHead(project, root);
        GitRevisionNumber originalRevision = GitMergeUtil.findOriginalRevisionNumber(project, root, (VcsRevisionNumber)yoursRevision, (VcsRevisionNumber)theirsRevision);
        Trinity<String, String, String> blobs = GitMergeUtil.getAffectedBlobs(project, root, path);
        FilePath originalPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getFirst(), (VcsRevisionNumber)originalRevision);
        FilePath yoursPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getSecond(), (VcsRevisionNumber)yoursRevision);
        FilePath theirsPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getThird(), (VcsRevisionNumber)theirsRevision);
        MergeData mergeData = new MergeData();
        mergeData.ORIGINAL = originalContent;
        mergeData.CURRENT = !isReversed ? yoursContent : theirsContent;
        mergeData.LAST = isReversed ? yoursContent : theirsContent;
        mergeData.ORIGINAL_REVISION_NUMBER = originalRevision;
        mergeData.CURRENT_REVISION_NUMBER = !isReversed ? yoursRevision : theirsRevision;
        mergeData.LAST_REVISION_NUMBER = isReversed ? yoursRevision : theirsRevision;
        mergeData.ORIGINAL_FILE_PATH = originalPath;
        mergeData.CURRENT_FILE_PATH = !isReversed ? yoursPath : theirsPath;
        mergeData.LAST_FILE_PATH = isReversed ? yoursPath : theirsPath;
        return mergeData;
    }

    @Nullable
    private static GitRevisionNumber findOriginalRevisionNumber(@NotNull Project project, @NotNull VirtualFile root, @Nullable VcsRevisionNumber yoursRevision, @Nullable VcsRevisionNumber theirsRevision) {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(3);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(4);
        }
        if (yoursRevision == null || theirsRevision == null) {
            return null;
        }
        try {
            return GitHistoryUtils.getMergeBase(project, root, yoursRevision.asString(), theirsRevision.asString());
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static GitRevisionNumber resolveMergeHead(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(5);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(6);
        }
        try {
            return GitRevisionNumber.resolve(project, root, "MERGE_HEAD");
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve the MERGE_HEAD in " + root + ": " + e.getMessage());
            try {
                return GitRevisionNumber.resolve(project, root, "CHERRY_PICK_HEAD");
            }
            catch (VcsException e2) {
                LOG.info("Couldn't resolve the CHERRY_PICK_HEAD in " + root + ": " + e2.getMessage());
                GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
                assert (repository != null);
                File rebaseApply = repository.getRepositoryFiles().getRebaseApplyDir();
                GitRevisionNumber rebaseRevision = GitMergeUtil.readRevisionFromFile(project, root, new File(rebaseApply, "original-commit"));
                if (rebaseRevision != null) {
                    return rebaseRevision;
                }
                File rebaseMerge = repository.getRepositoryFiles().getRebaseMergeDir();
                GitRevisionNumber mergeRevision = GitMergeUtil.readRevisionFromFile(project, root, new File(rebaseMerge, "stopped-sha"));
                if (mergeRevision != null) {
                    return mergeRevision;
                }
                return null;
            }
        }
    }

    @Nullable
    private static GitRevisionNumber readRevisionFromFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull File file) {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(7);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            GitMergeUtil.$$$reportNull$$$0(9);
        }
        if (!file.exists()) {
            return null;
        }
        String revision = DvcsUtil.tryLoadFileOrReturn((File)file, null, (String)"UTF-8");
        if (revision == null) {
            return null;
        }
        try {
            return GitRevisionNumber.resolve(project, root, revision);
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve revision  '" + revision + "' in " + root + ": " + e.getMessage());
            return null;
        }
    }

    @Nullable
    private static GitRevisionNumber resolveHead(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(10);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(11);
        }
        try {
            return GitRevisionNumber.resolve(project, root, "HEAD");
        }
        catch (VcsException e) {
            LOG.error("Couldn't resolve the HEAD in " + root, (Throwable)e);
            return null;
        }
    }

    private static byte @NotNull [] loadOriginalContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path) {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(12);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(13);
        }
        if (path == null) {
            GitMergeUtil.$$$reportNull$$$0(14);
        }
        try {
            return GitMergeUtil.loadRevisionContent(project, root, path, 1);
        }
        catch (Exception ex) {
            byte[] byArray;
            try {
                byArray = (byte[])ReadAction.compute(() -> {
                    VirtualFile file = path.getVirtualFile();
                    if (file == null || !file.isValid()) {
                        LOG.debug("File not found: " + path);
                        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
                    }
                    return file.contentsToByteArray();
                });
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                    GitMergeUtil.$$$reportNull$$$0(16);
                }
                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
            if (byArray == null) {
                GitMergeUtil.$$$reportNull$$$0(15);
            }
            return byArray;
        }
    }

    private static byte @NotNull [] loadRevisionCatchingErrors(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, int stageNum) throws VcsException {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(17);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(18);
        }
        if (path == null) {
            GitMergeUtil.$$$reportNull$$$0(19);
        }
        try {
            return GitMergeUtil.loadRevisionContent(project, root, path, stageNum);
        }
        catch (VcsException e) {
            String m = e.getMessage().trim();
            if (m.startsWith("fatal: ambiguous argument ") || m.startsWith("fatal: Path '") && m.contains("' exists on disk, but not in '") || m.contains("is in the index, but not at stage ") || m.contains("bad revision") || m.startsWith("fatal: Not a valid object name")) {
                if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                    GitMergeUtil.$$$reportNull$$$0(20);
                }
                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
            throw e;
        }
    }

    private static byte @NotNull [] loadRevisionContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, int stageNum) throws VcsException {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(21);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(22);
        }
        if (path == null) {
            GitMergeUtil.$$$reportNull$$$0(23);
        }
        byte[] byArray = GitFileUtils.getFileContent(project, root, ":" + stageNum, VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
        if (byArray == null) {
            GitMergeUtil.$$$reportNull$$$0(24);
        }
        return byArray;
    }

    @NotNull
    private static Trinity<String, String, String> getAffectedBlobs(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path) {
        Trinity trinity;
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(26);
        }
        if (path == null) {
            GitMergeUtil.$$$reportNull$$$0(27);
        }
        try {
            GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.LS_FILES);
            h2.addParameters("--exclude-standard", "--unmerged", "-z");
            h2.endOptions();
            h2.addRelativePaths(path);
            String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
            StringScanner s = new StringScanner(output);
            String originalBlob = null;
            String yoursBlob = null;
            String theirsBlob = null;
            while (s.hasMoreData()) {
                s.spaceToken();
                String blob = s.spaceToken();
                int source = Integer.parseInt(s.tabToken());
                s.boundedToken('\u0000');
                if (source == 1) {
                    originalBlob = blob;
                    continue;
                }
                if (source == 2) {
                    yoursBlob = blob;
                    continue;
                }
                if (source == 3) {
                    theirsBlob = blob;
                    continue;
                }
                throw new IllegalStateException("Unknown revision " + source + " for the file: " + path);
            }
            trinity = Trinity.create(originalBlob, yoursBlob, theirsBlob);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            Trinity trinity2 = Trinity.create(null, null, null);
            if (trinity2 == null) {
                GitMergeUtil.$$$reportNull$$$0(29);
            }
            return trinity2;
        }
        if (trinity == null) {
            GitMergeUtil.$$$reportNull$$$0(28);
        }
        return trinity;
    }

    @Nullable
    private static FilePath getBlobPathInRevision(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable String blob, @Nullable VcsRevisionNumber revision) {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(30);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(31);
        }
        if (path == null) {
            GitMergeUtil.$$$reportNull$$$0(32);
        }
        if (blob == null || revision == null) {
            return null;
        }
        FilePath revisionPath = GitMergeUtil.doGetBlobPathInRevision(project, root, blob, revision, path);
        if (revisionPath != null) {
            return revisionPath;
        }
        return GitMergeUtil.doGetBlobPathInRevision(project, root, blob, revision, null);
    }

    @Nullable
    private static FilePath doGetBlobPathInRevision(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull String blob, @NotNull VcsRevisionNumber revision, @Nullable FilePath path) {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(33);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(34);
        }
        if (blob == null) {
            GitMergeUtil.$$$reportNull$$$0(35);
        }
        if (revision == null) {
            GitMergeUtil.$$$reportNull$$$0(36);
        }
        final FilePath[] result2 = new FilePath[1];
        final boolean[] pathAmbiguous = new boolean[1];
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.LS_TREE);
        h2.addParameters(revision.asString());
        if (path != null) {
            h2.endOptions();
            h2.addRelativePaths(path);
        } else {
            h2.addParameters("-r");
            h2.endOptions();
        }
        h2.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (!line.contains(blob)) {
                    return;
                }
                if (pathAmbiguous[0]) {
                    return;
                }
                GitIndexUtil.StagedFileOrDirectory stagedFile = GitIndexUtil.parseListTreeRecord(root, line);
                if (stagedFile instanceof GitIndexUtil.StagedFile && blob.equals(((GitIndexUtil.StagedFile)stagedFile).getBlobHash())) {
                    if (result2[0] == null) {
                        result2[0] = stagedFile.getPath();
                    } else {
                        pathAmbiguous[0] = true;
                    }
                }
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h2);
        if (pathAmbiguous[0]) {
            return null;
        }
        return result2[0];
    }

    public static void acceptOneVersion(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends GitConflict> conflicts, @NotNull GitConflict.ConflictSide side) throws VcsException {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(37);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(38);
        }
        if (conflicts == null) {
            GitMergeUtil.$$$reportNull$$$0(39);
        }
        if (side == null) {
            GitMergeUtil.$$$reportNull$$$0(40);
        }
        boolean isCurrent = side == GitConflict.ConflictSide.OURS;
        for (GitConflict gitConflict : conflicts) {
            assert (root.equals(gitConflict.getRoot()));
        }
        ArrayList<FilePath> toCheckout = new ArrayList<FilePath>();
        for (GitConflict gitConflict : conflicts) {
            GitConflict.Status status = gitConflict.getStatus(side);
            FilePath filePath = gitConflict.getFilePath();
            if (status == GitConflict.Status.DELETED) continue;
            toCheckout.add(filePath);
        }
        for (List list : VcsFileUtil.chunkPaths((VirtualFile)root, toCheckout)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHECKOUT);
            handler.addParameters(isCurrent ? "--ours" : "--theirs");
            handler.endOptions();
            handler.addParameters(list);
            GitCommandResult result2 = Git.getInstance().runCommand(handler);
            if (result2.success()) continue;
            throw new VcsException(result2.getErrorOutputAsJoinedString());
        }
    }

    public static void markConflictResolved(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends GitConflict> conflicts, @Nullable GitConflict.ConflictSide side) throws VcsException {
        if (project == null) {
            GitMergeUtil.$$$reportNull$$$0(41);
        }
        if (root == null) {
            GitMergeUtil.$$$reportNull$$$0(42);
        }
        if (conflicts == null) {
            GitMergeUtil.$$$reportNull$$$0(43);
        }
        ArrayList<FilePath> toAdd = new ArrayList<FilePath>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        for (GitConflict gitConflict : conflicts) {
            FilePath filePath = gitConflict.getFilePath();
            if (side == null || gitConflict.getStatus(side) != GitConflict.Status.DELETED) {
                toAdd.add(filePath);
                continue;
            }
            toDelete.add(filePath);
        }
        GitFileUtils.addPathsForce(project, root, toAdd);
        GitFileUtils.deletePaths(project, root, toDelete, new String[0]);
    }

    public static boolean isReverseRoot(@NotNull GitRepository repository) {
        if (repository == null) {
            GitMergeUtil.$$$reportNull$$$0(44);
        }
        return repository.getState().equals((Object)Repository.State.REBASING);
    }

    public static String getDefaultStrategy() {
        return GitBundle.getString("merge.default.strategy");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 22: 
            case 26: 
            case 31: 
            case 34: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 14: 
            case 19: 
            case 23: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitMergeUtil";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blob";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitMergeUtil";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadOriginalContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisionCatchingErrors";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisionContent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedBlobs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadMergeData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalRevisionNumber";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveMergeHead";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readRevisionFromFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveHead";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadOriginalContent";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 29: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisionCatchingErrors";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisionContent";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedBlobs";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBlobPathInRevision";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doGetBlobPathInRevision";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "acceptOneVersion";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "markConflictResolved";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isReverseRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

