/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.test;

import com.intellij.debugger.streams.test.DslTestCase;
import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CodeContext;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b3\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J!\u0010\t\u001a\u00020\u00062\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\b\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0006J\u0006\u0010\u001a\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u0006J\u0006\u0010 \u001a\u00020\u0006J\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u0006J\u0006\u0010$\u001a\u00020\u0006J\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010'\u001a\u00020\u0006J\u0006\u0010(\u001a\u00020\u0006J\u0006\u0010)\u001a\u00020\u0006J\u0006\u0010*\u001a\u00020\u0006J\u0006\u0010+\u001a\u00020\u0006J\u0006\u0010,\u001a\u00020\u0006J\u0006\u0010-\u001a\u00020\u0006J\u0006\u0010.\u001a\u00020\u0006J\u0006\u0010/\u001a\u00020\u0006J\u0006\u00100\u001a\u00020\u0006J\u0006\u00101\u001a\u00020\u0006J\u0006\u00102\u001a\u00020\u0006J\u0006\u00103\u001a\u00020\u0006J\u0006\u00104\u001a\u00020\u0006J\u0006\u00105\u001a\u00020\u0006J\u0006\u00106\u001a\u00020\u0006J\u0006\u00107\u001a\u00020\u0006J\u0006\u00108\u001a\u00020\u0006J\u0006\u00109\u001a\u00020\u0006J\u0006\u0010:\u001a\u00020\u0006J\u0006\u0010;\u001a\u00020\u0006J\u0006\u0010<\u001a\u00020\u0006J\u0006\u0010=\u001a\u00020\u0006J\u0006\u0010>\u001a\u00020\u0006J\u0006\u0010?\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/debugger/streams/test/DslTestCase;", "Lcom/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase;", "dsl", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "(Lcom/intellij/debugger/streams/trace/dsl/Dsl;)V", "check", "", "actualText", "", "doTest", "init", "Lkotlin/Function1;", "Lcom/intellij/debugger/streams/trace/dsl/CodeContext;", "Lkotlin/ExtensionFunctionType;", "testArrayCreateFromElements", "testArrayDeclaration", "testArrayDefaultDeclaration", "testArrayElementAssignment", "testArrayElementUsage", "testAssignment", "testCall", "testCallManyArgs", "testCallOneArg", "testCodeBlockReturn", "testDeclareImmutableVariable", "testDeclareMutableVariable", "testDeclareVariableAndInit", "testForEach", "testForLoop", "testIf", "testIfElse", "testIfElseIf", "testIfElseIfElse", "testLambdaBlockReturn", "testLambdaExpressionReturn", "testLambdaWithCodeBlock", "testLambdaWithExpression", "testLinkedMapDeclaration", "testLinkedMapInitialization", "testListDeclaration", "testListOperations", "testLoopWithBreak", "testLoopWithNestedBreak", "testMapComputeIfAbsent", "testMapContains", "testMapConvertToArray", "testMapDeclaration", "testMapGet", "testMapInitialization", "testMapPut", "testMergeCodeBlocks", "testMergeCodeBlocksReversed", "testNegation", "testNestedAssignment", "testNestedScopes", "testNewList", "testNullableTypes", "testProperties", "testScope", "testSizedArrayCreation", "testTimeVariableDeclaration", "testTryBlock", "testTryWithUnspecifiedCatch", "testUseVariable", "intellij.java.debugger.streams"})
public abstract class DslTestCase
extends LightJavaCodeInsightFixtureTestCase {
    private final Dsl dsl;

    public final void testCall() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testCall.1.INSTANCE));
    }

    public final void testCallOneArg() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testCallOneArg.1.INSTANCE));
    }

    public final void testCallManyArgs() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testCallManyArgs.1.INSTANCE));
    }

    public final void testDeclareMutableVariable() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testDeclareMutableVariable.1.INSTANCE));
    }

    public final void testDeclareImmutableVariable() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testDeclareImmutableVariable.1.INSTANCE));
    }

    public final void testDeclareVariableAndInit() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testDeclareVariableAndInit.1.INSTANCE));
    }

    public final void testUseVariable() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testUseVariable.1.INSTANCE));
    }

    public final void testMergeCodeBlocks() {
        CodeBlock block2 = this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)testMergeCodeBlocks.block.1.INSTANCE));
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)new Function1<CodeContext, Unit>(block2){
            final /* synthetic */ CodeBlock $block;

            public final void invoke(@NotNull CodeContext $this$doTest) {
                Intrinsics.checkParameterIsNotNull((Object)$this$doTest, (String)"$receiver");
                $this$doTest.declare($this$doTest.variable($this$doTest.getTypes().getINT(), "a"), $this$doTest.getExpr("10"), false);
                $this$doTest.add(this.$block);
            }
            {
                this.$block = codeBlock;
                super(1);
            }
        }));
    }

    public final void testMergeCodeBlocksReversed() {
        CodeBlock block2 = this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)testMergeCodeBlocksReversed.block.1.INSTANCE));
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)new Function1<CodeContext, Unit>(block2){
            final /* synthetic */ CodeBlock $block;

            public final void invoke(@NotNull CodeContext $this$doTest) {
                Intrinsics.checkParameterIsNotNull((Object)$this$doTest, (String)"$receiver");
                $this$doTest.add(this.$block);
                $this$doTest.declare($this$doTest.variable($this$doTest.getTypes().getINT(), "b"), $this$doTest.getExpr("20"), false);
            }
            {
                this.$block = codeBlock;
                super(1);
            }
        }));
    }

    public final void testScope() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testScope.1.INSTANCE));
    }

    public final void testNestedScopes() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testNestedScopes.1.INSTANCE));
    }

    public final void testIf() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testIf.1.INSTANCE));
    }

    public final void testIfElse() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testIfElse.1.INSTANCE));
    }

    public final void testIfElseIf() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testIfElseIf.1.INSTANCE));
    }

    public final void testIfElseIfElse() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testIfElseIfElse.1.INSTANCE));
    }

    public final void testForEach() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testForEach.1.INSTANCE));
    }

    public final void testForLoop() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testForLoop.1.INSTANCE));
    }

    public final void testLoopWithBreak() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLoopWithBreak.1.INSTANCE));
    }

    public final void testLoopWithNestedBreak() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLoopWithNestedBreak.1.INSTANCE));
    }

    public final void testLambdaWithExpression() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLambdaWithExpression.1.INSTANCE));
    }

    public final void testLambdaWithCodeBlock() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLambdaWithCodeBlock.1.INSTANCE));
    }

    public final void testCodeBlockReturn() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testCodeBlockReturn.1.INSTANCE));
    }

    public final void testLambdaExpressionReturn() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLambdaExpressionReturn.1.INSTANCE));
    }

    public final void testLambdaBlockReturn() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLambdaBlockReturn.1.INSTANCE));
    }

    public final void testAssignment() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testAssignment.1.INSTANCE));
    }

    public final void testNestedAssignment() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testNestedAssignment.1.INSTANCE));
    }

    public final void testProperties() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testProperties.1.INSTANCE));
    }

    public final void testNegation() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testNegation.1.INSTANCE));
    }

    public final void testMapDeclaration() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testMapDeclaration.1.INSTANCE));
    }

    public final void testLinkedMapDeclaration() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLinkedMapDeclaration.1.INSTANCE));
    }

    public final void testMapGet() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testMapGet.1.INSTANCE));
    }

    public final void testMapPut() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testMapPut.1.INSTANCE));
    }

    public final void testMapContains() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testMapContains.1.INSTANCE));
    }

    public final void testMapInitialization() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testMapInitialization.1.INSTANCE));
    }

    public final void testLinkedMapInitialization() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testLinkedMapInitialization.1.INSTANCE));
    }

    public final void testMapComputeIfAbsent() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testMapComputeIfAbsent.1.INSTANCE));
    }

    public final void testListDeclaration() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testListDeclaration.1.INSTANCE));
    }

    public final void testListOperations() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testListOperations.1.INSTANCE));
    }

    public final void testNewList() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testNewList.1.INSTANCE));
    }

    public final void testArrayDeclaration() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testArrayDeclaration.1.INSTANCE));
    }

    public final void testArrayElementUsage() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testArrayElementUsage.1.INSTANCE));
    }

    public final void testArrayElementAssignment() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testArrayElementAssignment.1.INSTANCE));
    }

    public final void testArrayDefaultDeclaration() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testArrayDefaultDeclaration.1.INSTANCE));
    }

    public final void testArrayCreateFromElements() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testArrayCreateFromElements.1.INSTANCE));
    }

    public final void testMapConvertToArray() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testMapConvertToArray.1.INSTANCE));
    }

    public final void testNullableTypes() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testNullableTypes.1.INSTANCE));
    }

    public final void testTryBlock() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testTryBlock.1.INSTANCE));
    }

    public final void testTryWithUnspecifiedCatch() {
        this.assertException((AbstractExceptionCase)new AbstractExceptionCase<IllegalStateException>(this){
            final /* synthetic */ DslTestCase this$0;

            public void tryClosure() {
                DslTestCase.access$doTest(this.this$0, testTryWithUnspecifiedCatch.tryClosure.1.INSTANCE);
            }

            @NotNull
            public Class<IllegalStateException> getExpectedExceptionClass() {
                return IllegalStateException.class;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void testTimeVariableDeclaration() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testTimeVariableDeclaration.1.INSTANCE));
    }

    public final void testSizedArrayCreation() {
        this.doTest((Function1<? super CodeContext, Unit>)((Function1)testSizedArrayCreation.1.INSTANCE));
    }

    private final void doTest(Function1<? super CodeContext, Unit> init) {
        this.check(this.dsl.code(init));
    }

    private final void check(String actualText) {
        String string = this.getTestName(true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getTestName(true)");
        String testName = string;
        LightJavaCodeInsightFixtureTestCase.assertSameLinesWithFile((String)(this.getTestDataPath() + '/' + testName + ".out"), (String)actualText, (boolean)false);
    }

    public DslTestCase(@NotNull Dsl dsl) {
        Intrinsics.checkParameterIsNotNull((Object)dsl, (String)"dsl");
        this.dsl = dsl;
    }

    public static final /* synthetic */ void access$doTest(DslTestCase $this, Function1 init) {
        $this.doTest((Function1<? super CodeContext, Unit>)init);
    }
}

